/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDeploymentClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.ResponseHandlerService;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentsRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.SubmitDeploymentsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultJiraCloudDeploymentClient
implements JiraCloudDeploymentClient {
    private final JiraCloudHttpClient jiraCloudHttpClient;
    private final ResponseHandlerService responseHandlerService;

    public DefaultJiraCloudDeploymentClient(JiraCloudHttpClient jiraCloudHttpClient, ResponseHandlerService responseHandlerService) {
        this.jiraCloudHttpClient = jiraCloudHttpClient;
        this.responseHandlerService = responseHandlerService;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDeployments(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull DeploymentModel deploymentModel) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(deploymentModel, "deploymentModel");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/deployments/0.1/cloud/%s/pipelines/%s/environments/%s/deployments/%s", jiraSiteConfig.getCloudId(), deploymentModel.pipeline().id(), deploymentModel.environment().id(), deploymentModel.deploymentSequenceNumber())).build()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDeployments(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull Repository repository) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(repository, "repository");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/deployments/0.1/cloud/%s/bulkByProperties", jiraSiteConfig.getCloudId())).params(ModelConverter.getProperties(repository)).build()));
    }

    @Override
    @Nonnull
    public Promise<SubmitDeploymentsResponse> sendDeployments(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull DeploymentsRequest deploymentsRequest) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(deploymentsRequest, "deploymentsRequest");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makePostRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/deployments/0.1/cloud/%s/bulk", jiraSiteConfig.getCloudId())).requestPayload(deploymentsRequest).build(), SubmitDeploymentsResponse.class));
    }
}

