/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDevInfoClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.ResponseHandlerService;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInformation;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.SubmitDevInfoResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultJiraCloudDevInfoClient
implements JiraCloudDevInfoClient {
    private final JiraCloudHttpClient jiraCloudHttpClient;
    private final ResponseHandlerService responseHandlerService;

    public DefaultJiraCloudDevInfoClient(JiraCloudHttpClient jiraCloudHttpClient, ResponseHandlerService responseHandlerService) {
        this.jiraCloudHttpClient = jiraCloudHttpClient;
        this.responseHandlerService = responseHandlerService;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDevInfo(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull String cloudRepoId, @Nonnull DevInfoType type, @Nonnull String cloudEntityId) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(cloudRepoId, "cloudRepoId");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(cloudEntityId, "cloudEntityId");
        String entityTypeString = type.getEntityTypeForDeletion().orElseThrow(() -> new UnsupportedOperationException("Deletion for type [" + String.valueOf((Object)type) + "] not supported through this client"));
        String endpoint = String.format("/jira/devinfo/0.1/cloud/%s/repository/%s/%s/%s", jiraSiteConfig.getCloudId(), cloudRepoId, entityTypeString, cloudEntityId);
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(endpoint).build()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDevInfo(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull Repository repository) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(repository, "repository");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/devinfo/0.1/cloud/%s/bulkByProperties", jiraSiteConfig.getCloudId())).params(ModelConverter.getProperties(repository)).build()));
    }

    @Override
    @Nonnull
    public Promise<SubmitDevInfoResponse> sendDevInfo(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull DevInformation devInformation) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(devInformation, "devInformation");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makePostRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/devinfo/0.1/cloud/%s/bulk", jiraSiteConfig.getCloudId())).requestPayload(devInformation).build(), SubmitDevInfoResponse.class));
    }
}

