/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.AccessTokenClient;
import com.atlassian.stash.internal.jira.cloud.client.CloudClientConfiguration;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.exception.InvalidEndpointException;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutor;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutorFactory;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class DefaultJiraCloudHttpClient
implements JiraCloudHttpClient {
    private static final int MAX_PROPERTIES = 5;
    private final AccessTokenClient accessTokenClient;
    private final String baseUrl;
    private final HttpRequestExecutorFactory httpRequestExecutorFactory;
    private final I18nService i18nService;

    public DefaultJiraCloudHttpClient(AccessTokenClient accessTokenClient, CloudClientConfiguration cloudClientConfiguration, HttpRequestExecutorFactory httpRequestExecutorFactory, I18nService i18nService) {
        this.accessTokenClient = accessTokenClient;
        this.baseUrl = cloudClientConfiguration.getAtlassianApiUrl();
        this.httpRequestExecutorFactory = httpRequestExecutorFactory;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public Promise<Response> makeDeleteRequest(@Nonnull JiraCloudHttpRequest request) {
        Objects.requireNonNull(request, "request");
        return this.getExecutor(request.clientId(), request.clientSecret()).makeDeleteRequest(this.buildUrl(request.endpoint(), request.params()));
    }

    @Override
    @Nonnull
    public <T> Promise<T> makeGetRequest(@Nonnull JiraCloudHttpRequest request, @Nonnull Class<T> returnType) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(returnType, "returnType");
        return this.getExecutor(request.clientId(), request.clientSecret()).makeGetRequest(this.buildUrl(request.endpoint(), request.params()), returnType);
    }

    @Override
    public <T> Promise<T> makePostRequest(@Nonnull JiraCloudHttpRequest request, @Nonnull Class<T> returnType) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(returnType, "returnType");
        return this.getExecutor(request.clientId(), request.clientSecret()).makePostRequest(this.buildUrl(request.endpoint(), request.params()), request.requestPayload().orElse(null), returnType);
    }

    private String buildUrl(@Nonnull String endpoint, @Nullable Map<String, String> params) {
        Objects.requireNonNull(endpoint, "endpoint");
        try {
            URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath(endpoint);
            if (MapUtils.isNotEmpty(params)) {
                uriBuilder.addParameters(params.entrySet().stream().limit(5L).map(e -> new BasicNameValuePair((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
            }
            return uriBuilder.toString();
        }
        catch (URISyntaxException e2) {
            throw new InvalidEndpointException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.client.build.endpoint.failed", new Object[0]), e2);
        }
    }

    private HttpRequestExecutor getExecutor(@Nonnull String clientId, @Nonnull String clientSecret) {
        Objects.requireNonNull(clientId, "clientId");
        Objects.requireNonNull(clientSecret, "clientSecret");
        return this.httpRequestExecutorFactory.createAccessTokenBased(() -> this.accessTokenClient.getAccessToken(clientId, clientSecret).getAccessToken());
    }
}

