/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.jira.cloud.client.ResponseHandlerService;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigConnectionUpdateRequest;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import com.atlassian.stash.internal.jira.cloud.sync.ErrorMessageHandler;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseHandlerService
implements ResponseHandlerService {
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseHandlerService.class);
    private final ErrorMessageHandler errorMessageHandler;
    private final JiraSiteConfigService jiraSiteConfigService;
    private final EscalatedSecurityContext withAdmin;

    public DefaultResponseHandlerService(ErrorMessageHandler errorMessageHandler, JiraSiteConfigService jiraSiteConfigService, SecurityService securityService) {
        this.errorMessageHandler = errorMessageHandler;
        this.jiraSiteConfigService = jiraSiteConfigService;
        this.withAdmin = securityService.withPermission(Permission.ADMIN, "Connection status update");
    }

    @Override
    @Nonnull
    public <T> Promise<T> handleSuccessOrFail(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull Promise<T> response) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(response, "response");
        return response.done(r -> this.maybeUpdateConnectionStatus(jiraSiteConfig, JiraSiteConfigConnectionUpdateRequest.updateForSuccess(jiraSiteConfig.getId()))).fail(t -> {
            log.debug("Failed to make request to Jira Cloud", t);
            this.maybeUpdateConnectionStatus(jiraSiteConfig, this.errorMessageHandler.createConnectionUpdateRequest(jiraSiteConfig.getId(), (Throwable)t));
        });
    }

    private void maybeUpdateConnectionStatus(JiraSiteConfig siteConfig, JiraSiteConfigConnectionUpdateRequest updateRequest) {
        if (siteConfig.getConnectionStatus() == updateRequest.getStatus()) {
            return;
        }
        try {
            this.withAdmin.call(() -> this.jiraSiteConfigService.updateConnectionStatus(updateRequest));
        }
        catch (RuntimeException exception) {
            log.info("Unable to update Jira Cloud site connection status. Will update on next event. New status: {} ", (Object)updateRequest, (Object)exception);
        }
    }
}

