/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JiraCloudHttpRequest {
    private final String clientId;
    private final String clientSecret;
    private final String endpoint;
    private final Map<String, String> params;
    private final Object requestPayload;

    private JiraCloudHttpRequest(@Nonnull Builder builder) {
        Objects.requireNonNull(builder, "builder");
        this.clientId = Objects.requireNonNull(builder.clientId, "clientId");
        this.clientSecret = Objects.requireNonNull(builder.clientSecret, "clientSecret");
        this.endpoint = Objects.requireNonNull(builder.endpoint, "endpoint");
        this.params = builder.params.build();
        this.requestPayload = builder.requestPayload;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public String clientId() {
        return this.clientId;
    }

    @Nonnull
    public String clientSecret() {
        return this.clientSecret;
    }

    @Nonnull
    public String endpoint() {
        return this.endpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraCloudHttpRequest request = (JiraCloudHttpRequest)o;
        return Objects.equals(this.clientId, request.clientId) && Objects.equals(this.clientSecret, request.clientSecret) && Objects.equals(this.endpoint, request.endpoint) && Objects.equals(this.params, request.params) && Objects.equals(this.requestPayload, request.requestPayload);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.endpoint, this.params, this.requestPayload);
    }

    @Nonnull
    public Map<String, String> params() {
        return this.params;
    }

    @Nonnull
    public Optional<Object> requestPayload() {
        return Optional.ofNullable(this.requestPayload);
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        private String clientId;
        private String clientSecret;
        private String endpoint;
        private Object requestPayload;

        @Nonnull
        public JiraCloudHttpRequest build() {
            return new JiraCloudHttpRequest(this);
        }

        @Nonnull
        public Builder clientId(@Nonnull String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        @Nonnull
        public Builder clientSecret(@Nonnull String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @Nonnull
        public Builder endpoint(@Nonnull String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
            return this;
        }

        @Nonnull
        public Builder params(@Nonnull Map<String, String> params) {
            this.params.putAll(Objects.requireNonNull(params, "params"));
            return this;
        }

        @Nonnull
        public Builder requestPayload(@Nonnull Object requestPayload) {
            this.requestPayload = requestPayload;
            return this;
        }
    }
}

