/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.stash.internal.jira.cloud.client.CloudClientConfiguration;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsClient;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.client.model.PermissionsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraCloudPermissionsCache {
    private static final Logger log = LoggerFactory.getLogger(JiraCloudPermissionsCache.class);
    private final Cache<JiraSiteConfig, Set<JiraCloudOauthPermission>> cache;
    private final JiraCloudPermissionsClient permissionsClient;

    public JiraCloudPermissionsCache(CacheFactory cacheFactory, CloudClientConfiguration cloudClientConfiguration, JiraCloudPermissionsClient permissionsClient) {
        this.permissionsClient = permissionsClient;
        this.cache = cacheFactory.getCache(JiraCloudPermissionsCache.class.getName(), this::fetchPermissions, new CacheSettingsBuilder().local().expireAfterWrite((long)cloudClientConfiguration.getPermissionsCacheTtlSeconds(), TimeUnit.SECONDS).build());
    }

    @Nonnull
    public Set<JiraCloudOauthPermission> get(@Nonnull JiraSiteConfig jiraSiteConfig) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        try {
            return Objects.requireNonNull((Set)this.cache.get((Object)jiraSiteConfig), "Not expecting null PermissionsResponse");
        }
        catch (CacheException e) {
            log.error("Failed to fetch permissions for jira site: [name: {}, client id: {}]", new Object[]{jiraSiteConfig.getName(), jiraSiteConfig.getClientId(), e.getCause()});
            Throwables.propagateIfPossible((Throwable)e.getCause(), RuntimeException.class);
            throw e;
        }
    }

    public void invalidate(@Nonnull JiraSiteConfig jiraSiteConfig) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        this.cache.remove((Object)jiraSiteConfig);
    }

    private Set<JiraCloudOauthPermission> fetchPermissions(JiraSiteConfig jiraSiteConfig) {
        PermissionsResponse response = (PermissionsResponse)this.permissionsClient.getPermissions(jiraSiteConfig).claim();
        ImmutableSet.Builder permissions = ImmutableSet.builder();
        if (response.hasBuildsPermission()) {
            permissions.add((Object)JiraCloudOauthPermission.BUILDS);
        }
        if (response.hasDeploymentsPermission()) {
            permissions.add((Object)JiraCloudOauthPermission.DEPLOYMENTS);
        }
        if (response.hasDevInfoPermission()) {
            permissions.add((Object)JiraCloudOauthPermission.DEV_INFO);
        }
        return permissions.build();
    }
}

