/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.ResponseHandlerService;
import com.atlassian.stash.internal.jira.cloud.client.model.PermissionsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class JiraCloudPermissionsClient {
    private final JiraCloudHttpClient httpClient;
    private final ResponseHandlerService responseHandlerService;

    public JiraCloudPermissionsClient(JiraCloudHttpClient httpClient, ResponseHandlerService responseHandlerService) {
        this.httpClient = httpClient;
        this.responseHandlerService = responseHandlerService;
    }

    @Nonnull
    public Promise<PermissionsResponse> getPermissions(@Nonnull JiraSiteConfig jiraSiteConfig) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        JiraCloudHttpRequest request = JiraCloudHttpRequest.builder().endpoint(String.format("/jira/hudson/0.1/apps/%s/capabilities", jiraSiteConfig.getCloudId())).clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).build();
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.httpClient.makeGetRequest(request, PermissionsResponse.class));
    }
}

