/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsCache;
import com.atlassian.stash.internal.jira.cloud.client.exception.MissingOauthPermissionException;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.http.client.exception.HttpClientException;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JiraCloudPermissionsWrapper {
    private final JiraCloudPermissionsCache permissionsCache;

    public JiraCloudPermissionsWrapper(JiraCloudPermissionsCache permissionsCache) {
        this.permissionsCache = permissionsCache;
    }

    @Nonnull
    public <T> Promise<T> withPermission(JiraCloudOauthPermission permission, JiraSiteConfig jiraSiteConfig, Supplier<Promise<T>> operation) {
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        try {
            Set<JiraCloudOauthPermission> permissions = this.permissionsCache.get(jiraSiteConfig);
            return permissions.contains((Object)permission) ? this.performOperation(operation, jiraSiteConfig, permission) : Promises.rejected((Throwable)new MissingOauthPermissionException(permission));
        }
        catch (Throwable e) {
            return Promises.rejected((Throwable)e);
        }
    }

    private <T> Promise<T> performOperation(Supplier<Promise<T>> operation, JiraSiteConfig jiraSiteConfig, JiraCloudOauthPermission permission) {
        return operation.get().recover(this.checkForForbiddenException(jiraSiteConfig, permission));
    }

    private <T> Function<Throwable, T> checkForForbiddenException(JiraSiteConfig jiraSiteConfig, JiraCloudOauthPermission permission) {
        return throwable -> {
            if (throwable instanceof HttpClientException && ((HttpClientException)throwable).getErrorResponse().isForbidden()) {
                this.permissionsCache.invalidate(jiraSiteConfig);
                throw new MissingOauthPermissionException(permission);
            }
            throw new RuntimeException((Throwable)throwable);
        };
    }
}

