/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudBuildStatusClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsWrapper;
import com.atlassian.stash.internal.jira.cloud.client.exception.MissingOauthPermissionException;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.SubmitBuildsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PermissionsAwareJiraCloudBuildStatusClient
implements JiraCloudBuildStatusClient {
    private static final Logger log = LoggerFactory.getLogger(PermissionsAwareJiraCloudBuildStatusClient.class);
    private final JiraCloudBuildStatusClient delegate;
    private final JiraCloudPermissionsWrapper permissionsWrapper;

    public PermissionsAwareJiraCloudBuildStatusClient(JiraCloudPermissionsWrapper permissionsWrapper, JiraCloudBuildStatusClient delegate) {
        this.permissionsWrapper = permissionsWrapper;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteBuildStatus(JiraSiteConfig jiraSiteConfig, BuildStatusModel buildStatus) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.BUILDS, jiraSiteConfig, () -> this.delegate.deleteBuildStatus(jiraSiteConfig, buildStatus)).fail(PermissionsAwareJiraCloudBuildStatusClient.logIfMissingPermission("Unable to delete build status due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteBuildStatus(JiraSiteConfig jiraSiteConfig, Repository repository) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.BUILDS, jiraSiteConfig, () -> this.delegate.deleteBuildStatus(jiraSiteConfig, repository)).fail(PermissionsAwareJiraCloudBuildStatusClient.logIfMissingPermission("Unable to delete build status due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<SubmitBuildsResponse> sendBuildStatus(JiraSiteConfig jiraSiteConfig, BuildStatusRequest buildStatusRequest) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.BUILDS, jiraSiteConfig, () -> this.delegate.sendBuildStatus(jiraSiteConfig, buildStatusRequest)).fail(PermissionsAwareJiraCloudBuildStatusClient.logIfMissingPermission("Unable to send build status request due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    private static Consumer<Throwable> logIfMissingPermission(String message, Object ... parameters) {
        return throwable -> {
            if (throwable instanceof MissingOauthPermissionException) {
                log.debug(message, parameters);
            }
        };
    }
}

