/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDeploymentClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsWrapper;
import com.atlassian.stash.internal.jira.cloud.client.exception.MissingOauthPermissionException;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentsRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.SubmitDeploymentsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PermissionsAwareJiraCloudDeploymentClient
implements JiraCloudDeploymentClient {
    private static final Logger log = LoggerFactory.getLogger(PermissionsAwareJiraCloudDeploymentClient.class);
    private final JiraCloudDeploymentClient delegate;
    private final JiraCloudPermissionsWrapper permissionsWrapper;

    public PermissionsAwareJiraCloudDeploymentClient(JiraCloudPermissionsWrapper permissionsWrapper, JiraCloudDeploymentClient delegate) {
        this.permissionsWrapper = permissionsWrapper;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDeployments(JiraSiteConfig jiraSiteConfig, DeploymentModel deploymentModel) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEPLOYMENTS, jiraSiteConfig, () -> this.delegate.deleteDeployments(jiraSiteConfig, deploymentModel)).fail(PermissionsAwareJiraCloudDeploymentClient.logIfMissingPermission("Unable to delete deployment due to missing permission for the OAuth credentials: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDeployments(JiraSiteConfig jiraSiteConfig, Repository repository) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEPLOYMENTS, jiraSiteConfig, () -> this.delegate.deleteDeployments(jiraSiteConfig, repository)).fail(PermissionsAwareJiraCloudDeploymentClient.logIfMissingPermission("Unable to delete deployment due to missing permission for the OAuth credentials: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<SubmitDeploymentsResponse> sendDeployments(JiraSiteConfig jiraSiteConfig, DeploymentsRequest deploymentsRequest) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEPLOYMENTS, jiraSiteConfig, () -> this.delegate.sendDeployments(jiraSiteConfig, deploymentsRequest)).fail(PermissionsAwareJiraCloudDeploymentClient.logIfMissingPermission("Unable to send deployment information due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    private static Consumer<Throwable> logIfMissingPermission(String message, Object ... parameters) {
        return throwable -> {
            if (throwable instanceof MissingOauthPermissionException) {
                log.debug(message, parameters);
            }
        };
    }
}

