/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDevInfoClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsWrapper;
import com.atlassian.stash.internal.jira.cloud.client.exception.MissingOauthPermissionException;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInformation;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.SubmitDevInfoResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PermissionsAwareJiraCloudDevInfoClient
implements JiraCloudDevInfoClient {
    private static final Logger log = LoggerFactory.getLogger(PermissionsAwareJiraCloudDevInfoClient.class);
    private final JiraCloudDevInfoClient delegate;
    private final JiraCloudPermissionsWrapper permissionsWrapper;

    public PermissionsAwareJiraCloudDevInfoClient(JiraCloudPermissionsWrapper permissionsWrapper, JiraCloudDevInfoClient delegate) {
        this.permissionsWrapper = permissionsWrapper;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDevInfo(JiraSiteConfig jiraSiteConfig, String cloudRepoId, DevInfoType type, String cloudEntityId) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEV_INFO, jiraSiteConfig, () -> this.delegate.deleteDevInfo(jiraSiteConfig, cloudRepoId, type, cloudEntityId)).fail(PermissionsAwareJiraCloudDevInfoClient.logIfMissingPermission("Unable to delete dev info due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteDevInfo(JiraSiteConfig jiraSiteConfig, Repository repository) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEV_INFO, jiraSiteConfig, () -> this.delegate.deleteDevInfo(jiraSiteConfig, repository)).fail(PermissionsAwareJiraCloudDevInfoClient.logIfMissingPermission("Unable to delete dev info due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    @Override
    @Nonnull
    public Promise<SubmitDevInfoResponse> sendDevInfo(JiraSiteConfig jiraSiteConfig, DevInformation devInformation) {
        return this.permissionsWrapper.withPermission(JiraCloudOauthPermission.DEV_INFO, jiraSiteConfig, () -> this.delegate.sendDevInfo(jiraSiteConfig, devInformation)).fail(PermissionsAwareJiraCloudDevInfoClient.logIfMissingPermission("Unable to send dev info due to missing permission for the Jira site: {}", jiraSiteConfig.getName()));
    }

    private static Consumer<Throwable> logIfMissingPermission(String message, Object ... parameters) {
        return throwable -> {
            if (throwable instanceof MissingOauthPermissionException) {
                log.debug(message, parameters);
            }
        };
    }
}

