/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import javax.annotation.ParametersAreNonnullByDefault;

@JsonIgnoreProperties(ignoreUnknown=true)
@ParametersAreNonnullByDefault
public class AccessTokenResponse {
    private static final int ACCESS_TOKEN_EAGER_EXPIRY_SEC = 600;
    @JsonProperty
    private final String accessToken;
    @JsonProperty
    private final int expiryInSeconds;
    @JsonProperty
    private final String scope;
    @JsonProperty
    private final String tokenType;
    @JsonIgnore
    private final long expiryTimeInMillis;
    @JsonIgnore
    private final Instant instant = Instant.now();

    @JsonCreator
    public AccessTokenResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="expires_in") int expiryInSeconds, @JsonProperty(value="scope") String scope, @JsonProperty(value="token_type") String tokenType) {
        this(Clock.systemUTC(), accessToken, expiryInSeconds, scope, tokenType);
    }

    @JsonIgnore
    public AccessTokenResponse(Clock clock, String accessToken, int expiryInSeconds, String scope, String tokenType) {
        this.accessToken = accessToken;
        this.expiryInSeconds = expiryInSeconds;
        this.scope = scope;
        this.tokenType = tokenType;
        this.expiryTimeInMillis = clock.instant().plusSeconds(expiryInSeconds - 600).toEpochMilli();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiryInSeconds() {
        return this.expiryInSeconds;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.instant.toEpochMilli() > this.expiryTimeInMillis;
    }
}

