/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model;

import com.atlassian.stash.internal.jira.cloud.client.model.AssociationType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class AssociationModel {
    private static final String ASSOCIATION_TYPE = "associationType";
    private static final String VALUES = "values";
    private final String associationType;
    private final Set<String> values;

    @JsonCreator
    private AssociationModel(@JsonProperty(value="associationType") @Nonnull String associationType, @JsonProperty(value="values") @Nonnull Set<String> values) {
        this.associationType = associationType;
        this.values = Objects.requireNonNull(values, VALUES);
    }

    @JsonProperty(value="associationType")
    @Nonnull
    public String associationType() {
        return this.associationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationModel that = (AssociationModel)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    @JsonProperty(value="values")
    @Nonnull
    public Set<String> values() {
        return this.values;
    }

    public static final class Builder {
        private String associationType;
        private final ImmutableSet.Builder<String> valuesBuilder = ImmutableSet.builder();

        @Nonnull
        public Builder associationType(@Nonnull AssociationType associationType) {
            Objects.requireNonNull(associationType, AssociationModel.ASSOCIATION_TYPE);
            this.associationType = associationType.getType();
            return this;
        }

        @Nonnull
        public AssociationModel build() {
            return new AssociationModel(this.associationType, (Set<String>)this.valuesBuilder.build());
        }

        @Nonnull
        public Builder values(@Nonnull Set<String> values) {
            this.valuesBuilder.addAll((Iterable)Objects.requireNonNull(values, AssociationModel.VALUES));
            return this;
        }
    }
}

