/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

public abstract class JiraCloudRequest {
    protected static final String PROPERTIES = "properties";
    protected static final String PROVIDER_METADATA = "providerMetadata";
    private final Map<String, String> properties;
    private final Map<String, String> providerMetadata;

    protected JiraCloudRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        Objects.requireNonNull(builder, "builder");
        this.properties = builder.propertiesBuilder.build();
        this.providerMetadata = builder.providerMetadataBuilder.build();
    }

    protected JiraCloudRequest(@Nullable Map<String, String> properties, @Nullable Map<String, String> providerMetadata) {
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.providerMetadata = providerMetadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(providerMetadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraCloudRequest that = (JiraCloudRequest)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.providerMetadata, that.providerMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.providerMetadata);
    }

    @JsonProperty(value="properties")
    @Nonnull
    public Map<String, String> properties() {
        return this.properties;
    }

    @JsonProperty(value="providerMetadata")
    @Nonnull
    public Map<String, String> providerMetadata() {
        return this.providerMetadata;
    }

    public String toString() {
        return this.payloadStringHelper().add(PROPERTIES, this.properties).add(PROVIDER_METADATA, this.providerMetadata).toString();
    }

    @Nonnull
    protected abstract MoreObjects.ToStringHelper payloadStringHelper();

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends JiraCloudRequest> {
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, String> providerMetadataBuilder = ImmutableMap.builder();

        @Nonnull
        public abstract R build();

        @Nonnull
        public B properties(@Nonnull Map<String, String> properties) {
            Objects.requireNonNull(properties, JiraCloudRequest.PROPERTIES);
            this.propertiesBuilder.putAll(properties);
            return this.self();
        }

        @Nonnull
        public B providerMetadata(@Nonnull Map<String, String> providerMetadata) {
            Objects.requireNonNull(providerMetadata, JiraCloudRequest.PROVIDER_METADATA);
            this.providerMetadataBuilder.putAll(providerMetadata);
            return this.self();
        }

        @Nonnull
        public abstract B self();
    }
}

