/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.buildstatus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class BuildKeyModel {
    private static final String BUILD_NUMBER = "buildNumber";
    private static final String PIPELINE_ID = "pipelineId";
    private final long buildNumber;
    private final String pipelineId;

    @JsonCreator
    public BuildKeyModel(@JsonProperty(value="buildNumber") long buildNumber, @JsonProperty(value="pipelineId") @Nonnull String pipelineId) {
        this.buildNumber = buildNumber;
        this.pipelineId = Objects.requireNonNull(pipelineId, PIPELINE_ID);
    }

    @JsonProperty(value="buildNumber")
    public long buildNumber() {
        return this.buildNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildKeyModel that = (BuildKeyModel)o;
        return this.buildNumber == that.buildNumber && Objects.equals(this.pipelineId, that.pipelineId);
    }

    public int hashCode() {
        return Objects.hash(this.buildNumber, this.pipelineId);
    }

    @JsonProperty(value="pipelineId")
    @Nonnull
    public String pipelineId() {
        return this.pipelineId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(BuildKeyModel.class).add(BUILD_NUMBER, this.buildNumber).add(PIPELINE_ID, (Object)this.pipelineId).toString();
    }
}

