/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.buildstatus;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildReferencesModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.CloudBuildState;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.TestInfoModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class BuildStatusModel {
    private static final String BUILD_NUMBER = "buildNumber";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ISSUE_KEYS = "issueKeys";
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String PIPELINE_ID = "pipelineId";
    private static final String REFERENCES = "references";
    private static final String SCHEMA_VERSION = "schemaVersion";
    private static final String SUPPORTED_SCHEMA_VERSION = "1.0";
    private static final String STATE = "state";
    private static final String TEST_INFO = "testInfo";
    private static final String UPDATE_SEQUENCE_NUMBER = "updateSequenceNumber";
    private static final String URL = "url";
    private final long buildNumber;
    private final String description;
    private final String displayName;
    private final Set<String> issueKeys;
    private final String lastUpdated;
    private final String pipelineId;
    private final List<BuildReferencesModel> references;
    private final String state;
    private final TestInfoModel testInfo;
    private final long updateSequenceNumber;
    private final String url;

    @JsonCreator
    private BuildStatusModel(@JsonProperty(value="buildNumber") long buildNumber, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="issueKeys") @Nonnull Set<String> issueKeys, @JsonProperty(value="lastUpdated") @Nonnull String lastUpdated, @JsonProperty(value="pipelineId") @Nonnull String pipelineId, @JsonProperty(value="references") @Nonnull List<BuildReferencesModel> references, @JsonProperty(value="state") @Nonnull String state, @JsonProperty(value="testInfo") @Nullable TestInfoModel testInfo, @JsonProperty(value="updateSequenceNumber") long updateSequenceNumber, @JsonProperty(value="url") @Nonnull String url) {
        this.buildNumber = buildNumber;
        this.description = description;
        this.displayName = Objects.requireNonNull(displayName, DISPLAY_NAME);
        this.issueKeys = Objects.requireNonNull(issueKeys, ISSUE_KEYS);
        this.lastUpdated = Objects.requireNonNull(lastUpdated, LAST_UPDATED);
        this.pipelineId = Objects.requireNonNull(pipelineId, PIPELINE_ID);
        this.references = Objects.requireNonNull(references);
        this.state = Objects.requireNonNull(state, STATE);
        this.testInfo = testInfo;
        this.updateSequenceNumber = updateSequenceNumber;
        this.url = Objects.requireNonNull(url, URL);
    }

    @JsonProperty(value="buildNumber")
    public long buildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonProperty(value="displayName")
    @Nonnull
    public String displayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStatusModel that = (BuildStatusModel)o;
        return this.buildNumber == that.buildNumber && this.updateSequenceNumber == that.updateSequenceNumber && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.issueKeys, that.issueKeys) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.pipelineId, that.pipelineId) && Objects.equals(this.references, that.references) && Objects.equals(this.state, that.state) && Objects.equals(this.testInfo, that.testInfo) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.buildNumber, this.description, this.displayName, this.issueKeys, this.lastUpdated, this.pipelineId, this.references, this.state, this.testInfo, this.updateSequenceNumber, this.url);
    }

    @JsonProperty(value="issueKeys")
    @Nonnull
    public Set<String> issueKeys() {
        return this.issueKeys;
    }

    @JsonProperty(value="lastUpdated")
    @Nonnull
    public String lastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="pipelineId")
    @Nonnull
    public String pipelineId() {
        return this.pipelineId;
    }

    @JsonProperty(value="references")
    @Nonnull
    public List<BuildReferencesModel> references() {
        return this.references;
    }

    @JsonProperty(value="schemaVersion")
    @Nonnull
    public String schemaVersion() {
        return SUPPORTED_SCHEMA_VERSION;
    }

    @JsonProperty(value="state")
    @Nonnull
    public String state() {
        return this.state;
    }

    @JsonProperty(value="testInfo")
    @Nullable
    public TestInfoModel testInfo() {
        return this.testInfo;
    }

    @JsonProperty(value="updateSequenceNumber")
    public long updateSequenceNumber() {
        return this.updateSequenceNumber;
    }

    @JsonProperty(value="url")
    @Nonnull
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private final ImmutableSet.Builder<String> issueKeysBuilder = ImmutableSet.builder();
        private final ImmutableList.Builder<BuildReferencesModel> referencesBuilder = ImmutableList.builder();
        private long buildNumber;
        private String description;
        private String displayName;
        private String lastUpdated;
        private String pipelineId;
        private String state;
        private TestInfoModel testInfo;
        private long updateSequenceNumber;
        private String url;

        @Nonnull
        public BuildStatusModel build() {
            return new BuildStatusModel(this.buildNumber, this.description, this.displayName, (Set<String>)this.issueKeysBuilder.build(), this.lastUpdated, this.pipelineId, (List<BuildReferencesModel>)this.referencesBuilder.build(), this.state, this.testInfo, this.updateSequenceNumber, this.url);
        }

        @Nonnull
        public Builder buildNumber(long buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, BuildStatusModel.DISPLAY_NAME);
            return this;
        }

        @Nonnull
        public Builder issueKeys(@Nonnull Set<String> issueKeys) {
            this.issueKeysBuilder.addAll((Iterable)Objects.requireNonNull(issueKeys, BuildStatusModel.ISSUE_KEYS));
            return this;
        }

        @Nonnull
        public Builder lastUpdated(@Nonnull String lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated, BuildStatusModel.LAST_UPDATED);
            return this;
        }

        @Nonnull
        public Builder pipelineId(@Nonnull String pipelineId) {
            this.pipelineId = Objects.requireNonNull(pipelineId, BuildStatusModel.PIPELINE_ID);
            return this;
        }

        @Nonnull
        public Builder reference(@Nonnull BuildReferencesModel reference) {
            this.referencesBuilder.add((Object)Objects.requireNonNull(reference, "reference"));
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState internalState) {
            Objects.requireNonNull(internalState, "internalState");
            this.state = CloudBuildState.fromInternalState(internalState).name().toLowerCase(Locale.ROOT);
            return this;
        }

        @Nonnull
        public Builder testInfo(@Nullable TestInfoModel testInfo) {
            this.testInfo = testInfo;
            return this;
        }

        @Nonnull
        public Builder updateSequenceNumber(long updateSequenceNumber) {
            this.updateSequenceNumber = updateSequenceNumber;
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String url) {
            this.url = Objects.requireNonNull(url, BuildStatusModel.URL);
            return this;
        }
    }
}

