/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.buildstatus;

import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildStatusRequest
extends JiraCloudRequest {
    private static final String BUILDS = "builds";
    private final List<BuildStatusModel> builds;

    private BuildStatusRequest(@Nonnull Builder builder) {
        super(builder);
        Objects.requireNonNull(builder, "builder");
        this.builds = builder.buildStatuses.build();
    }

    @JsonCreator
    private BuildStatusRequest(@JsonProperty(value="builds") @Nullable List<BuildStatusModel> builds, @JsonProperty(value="properties") @Nullable Map<String, String> properties, @JsonProperty(value="providerMetadata") @Nullable Map<String, String> providerMetadata) {
        super(properties, providerMetadata);
        this.builds = builds == null ? ImmutableList.of() : ImmutableList.copyOf(builds);
    }

    @JsonProperty(value="builds")
    @Nonnull
    public List<BuildStatusModel> builds() {
        return this.builds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStatusRequest that = (BuildStatusRequest)o;
        return Objects.equals(this.builds, that.builds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.builds);
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper payloadStringHelper() {
        return MoreObjects.toStringHelper(BuildStatusRequest.class).add(BUILDS, this.builds);
    }

    public static class Builder
    extends JiraCloudRequest.AbstractBuilder<Builder, BuildStatusRequest> {
        private final ImmutableList.Builder<BuildStatusModel> buildStatuses = ImmutableList.builder();

        @Override
        @Nonnull
        public BuildStatusRequest build() {
            return new BuildStatusRequest(this);
        }

        @Nonnull
        public Builder buildStatus(@Nonnull BuildStatusModel buildStatus) {
            this.buildStatuses.add((Object)Objects.requireNonNull(buildStatus, "buildStatus"));
            return this;
        }

        @Nonnull
        public Builder buildStatuses(@Nonnull List<BuildStatusModel> buildStatuses) {
            buildStatuses.addAll((Collection<BuildStatusModel>)Objects.requireNonNull(buildStatuses, "buildStatuses"));
            return this;
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }
    }
}

