/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.buildstatus;

import com.atlassian.stash.internal.jira.cloud.client.model.ErrorMessage;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildKeyModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RejectedBuildModel {
    private static final String BUILD_KEY = "key";
    private static final String ERRORS = "errors";
    private final BuildKeyModel buildKey;
    private final List<ErrorMessage> errors;

    @JsonCreator
    public RejectedBuildModel(@JsonProperty(value="key") @Nonnull BuildKeyModel buildKey, @JsonProperty(value="errors") @Nonnull List<ErrorMessage> errors) {
        this.buildKey = Objects.requireNonNull(buildKey, "buildKey");
        this.errors = ImmutableList.copyOf((Collection)Objects.requireNonNull(errors, ERRORS));
    }

    @JsonProperty(value="key")
    @Nonnull
    public BuildKeyModel buildKey() {
        return this.buildKey;
    }

    @JsonProperty(value="errors")
    @Nonnull
    public List<ErrorMessage> errors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectedBuildModel that = (RejectedBuildModel)o;
        return Objects.equals(this.buildKey, that.buildKey) && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.buildKey, this.errors);
    }

    public String toString() {
        return MoreObjects.toStringHelper(RejectedBuildModel.class).add(BUILD_KEY, (Object)this.buildKey).add(ERRORS, this.errors).toString();
    }
}

