/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.buildstatus;

import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudResponse;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildKeyModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.RejectedBuildModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class SubmitBuildsResponse
extends JiraCloudResponse {
    private static final String ACCEPTED_BUILDS = "acceptedBuilds";
    private static final String REJECTED_BUILDS = "rejectedBuilds";
    private final List<BuildKeyModel> acceptedBuilds;
    private final List<RejectedBuildModel> rejectedBuilds;

    @JsonCreator
    public SubmitBuildsResponse(@JsonProperty(value="acceptedBuilds") List<BuildKeyModel> acceptedBuilds, @JsonProperty(value="rejectedBuilds") List<RejectedBuildModel> rejectedBuilds, @JsonProperty(value="unknownIssueKeys") Set<String> unknownIssueKeys) {
        super(unknownIssueKeys);
        this.acceptedBuilds = acceptedBuilds == null ? ImmutableList.of() : ImmutableList.copyOf(acceptedBuilds);
        this.rejectedBuilds = rejectedBuilds == null ? ImmutableList.of() : ImmutableList.copyOf(rejectedBuilds);
    }

    @JsonProperty(value="acceptedBuilds")
    @Nonnull
    public List<BuildKeyModel> acceptedBuilds() {
        return this.acceptedBuilds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubmitBuildsResponse that = (SubmitBuildsResponse)o;
        return Objects.equals(this.acceptedBuilds, that.acceptedBuilds) && Objects.equals(this.rejectedBuilds, that.rejectedBuilds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.acceptedBuilds, this.rejectedBuilds);
    }

    @JsonProperty(value="rejectedBuilds")
    @Nonnull
    public List<RejectedBuildModel> rejectedBuilds() {
        return this.rejectedBuilds;
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper payloadStringHelper() {
        return MoreObjects.toStringHelper(SubmitBuildsResponse.class).add(ACCEPTED_BUILDS, this.acceptedBuilds).add(REJECTED_BUILDS, this.rejectedBuilds);
    }
}

