/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.deployment;

import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.stash.internal.jira.cloud.client.model.AssociationModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.EnvironmentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.PipelineModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class DeploymentModel {
    private static final String ASSOCIATIONS = "associations";
    private static final String DEPLOYMENT_SEQUENCE_NUMBER = "deploymentSequenceNumber";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENVIRONMENT = "environment";
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String PIPELINE = "pipeline";
    private static final String SCHEMA_VERSION = "schemaVersion";
    private static final String SUPPORTED_SCHEMA_VERSION = "1.0";
    private static final String STATE = "state";
    private static final String UPDATE_SEQUENCE_NUMBER = "updateSequenceNumber";
    private static final String URL = "url";
    private final List<AssociationModel> associations;
    private final long deploymentSequenceNumber;
    private final String description;
    private final String displayName;
    private final EnvironmentModel environment;
    private final String lastUpdated;
    private final PipelineModel pipeline;
    private final String state;
    private final long updateSequenceNumber;
    private final String url;

    @JsonCreator
    private DeploymentModel(@JsonProperty(value="associations") @Nonnull List<AssociationModel> associations, @JsonProperty(value="deploymentSequenceNumber") long deploymentSequenceNumber, @JsonProperty(value="description") @Nonnull String description, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="environment") @Nonnull EnvironmentModel environment, @JsonProperty(value="lastUpdated") @Nonnull String lastUpdated, @JsonProperty(value="pipeline") @Nonnull PipelineModel pipeline, @JsonProperty(value="state") @Nonnull String state, @JsonProperty(value="updateSequenceNumber") long updateSequenceNumber, @JsonProperty(value="url") @Nonnull String url) {
        this.associations = Objects.requireNonNull(associations, ASSOCIATIONS);
        this.deploymentSequenceNumber = deploymentSequenceNumber;
        this.description = Objects.requireNonNull(description, DESCRIPTION);
        this.displayName = Objects.requireNonNull(displayName, DISPLAY_NAME);
        this.environment = Objects.requireNonNull(environment, ENVIRONMENT);
        this.lastUpdated = Objects.requireNonNull(lastUpdated, LAST_UPDATED);
        this.pipeline = Objects.requireNonNull(pipeline, PIPELINE);
        this.state = Objects.requireNonNull(state, STATE);
        this.updateSequenceNumber = updateSequenceNumber;
        this.url = Objects.requireNonNull(url, URL);
    }

    @JsonProperty(value="associations")
    @Nonnull
    public List<AssociationModel> associations() {
        return this.associations;
    }

    @JsonProperty(value="deploymentSequenceNumber")
    public long deploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    @JsonProperty(value="description")
    @Nonnull
    public String description() {
        return this.description;
    }

    @JsonProperty(value="displayName")
    @Nonnull
    public String displayName() {
        return this.displayName;
    }

    @JsonProperty(value="environment")
    @Nonnull
    public EnvironmentModel environment() {
        return this.environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentModel that = (DeploymentModel)o;
        return this.deploymentSequenceNumber == that.deploymentSequenceNumber && this.updateSequenceNumber == that.updateSequenceNumber && Objects.equals(this.associations, that.associations) && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.environment, that.environment) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.pipeline, that.pipeline) && Objects.equals(this.state, that.state) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.associations, this.deploymentSequenceNumber, this.description, this.displayName, this.environment, this.lastUpdated, this.pipeline, this.state, this.updateSequenceNumber, this.url);
    }

    @JsonProperty(value="lastUpdated")
    @Nonnull
    public String lastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="pipeline")
    @Nonnull
    public PipelineModel pipeline() {
        return this.pipeline;
    }

    @JsonProperty(value="schemaVersion")
    @Nonnull
    public String schemaVersion() {
        return SUPPORTED_SCHEMA_VERSION;
    }

    @JsonProperty(value="state")
    @Nonnull
    public String state() {
        return this.state;
    }

    @JsonProperty(value="updateSequenceNumber")
    public long updateSequenceNumber() {
        return this.updateSequenceNumber;
    }

    @JsonProperty(value="url")
    @Nonnull
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private final ImmutableList.Builder<AssociationModel> associationsBuilder = ImmutableList.builder();
        private long deploymentSequenceNumber;
        private String description;
        private String displayName;
        private EnvironmentModel environment;
        private String lastUpdated;
        private PipelineModel pipeline;
        private String state;
        private long updateSequenceNumber;
        private String url;

        @Nonnull
        public Builder association(@Nonnull AssociationModel association) {
            this.associationsBuilder.add((Object)Objects.requireNonNull(association, "association"));
            return this;
        }

        @Nonnull
        public DeploymentModel build() {
            return new DeploymentModel((List<AssociationModel>)this.associationsBuilder.build(), this.deploymentSequenceNumber, this.description, this.displayName, this.environment, this.lastUpdated, this.pipeline, this.state, this.updateSequenceNumber, this.url);
        }

        @Nonnull
        public Builder deploymentSequenceNumber(long deploymentSequenceNumber) {
            this.deploymentSequenceNumber = deploymentSequenceNumber;
            return this;
        }

        @Nonnull
        public Builder description(@Nonnull String description) {
            this.description = Objects.requireNonNull(description, DeploymentModel.DESCRIPTION);
            return this;
        }

        @Nonnull
        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, DeploymentModel.DISPLAY_NAME);
            return this;
        }

        @Nonnull
        public Builder environment(@Nonnull EnvironmentModel environment) {
            this.environment = Objects.requireNonNull(environment, DeploymentModel.ENVIRONMENT);
            return this;
        }

        @Nonnull
        public Builder lastUpdated(@Nonnull String lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated, DeploymentModel.LAST_UPDATED);
            return this;
        }

        @Nonnull
        public Builder pipeline(@Nonnull PipelineModel pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, DeploymentModel.PIPELINE);
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull DeploymentState internalState) {
            Objects.requireNonNull(internalState, "internalState");
            this.state = internalState.name().toLowerCase();
            return this;
        }

        @Nonnull
        public Builder updateSequenceNumber(long updateSequenceNumber) {
            this.updateSequenceNumber = updateSequenceNumber;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = Objects.requireNonNull(url, DeploymentModel.URL);
            return this;
        }
    }
}

