/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.deployment;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class EnvironmentModel {
    private static final String ID = "id";
    private static final String DISPLAY_NAME = "displayName";
    private static final String TYPE = "type";
    private static final String UNMAPPED_ENVIRONMENT_TYPE = "unmapped";
    private final String id;
    private final String displayName;
    private final String type;

    @JsonCreator
    private EnvironmentModel(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="type") @Nonnull String type) {
        this.id = Objects.requireNonNull(id, ID);
        this.displayName = Objects.requireNonNull(displayName, DISPLAY_NAME);
        this.type = Objects.requireNonNull(type, TYPE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentModel that = (EnvironmentModel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.type);
    }

    @JsonProperty(value="id")
    @Nonnull
    public String id() {
        return this.id;
    }

    @JsonProperty(value="displayName")
    @Nonnull
    public String displayName() {
        return this.displayName;
    }

    @JsonProperty(value="type")
    @Nonnull
    public String type() {
        return this.type;
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String type;

        @Nonnull
        public EnvironmentModel build() {
            return new EnvironmentModel(this.id, this.displayName, this.type);
        }

        @Nonnull
        public Builder id(@Nonnull String id) {
            this.id = Objects.requireNonNull(id, EnvironmentModel.ID);
            return this;
        }

        @Nonnull
        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, EnvironmentModel.DISPLAY_NAME);
            return this;
        }

        @Nonnull
        public Builder type(@Nullable DeploymentEnvironmentType internalType) {
            this.type = internalType == null ? EnvironmentModel.UNMAPPED_ENVIRONMENT_TYPE : internalType.name().toLowerCase();
            return this;
        }
    }
}

