/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.deployment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PipelineModel {
    private static final String ID = "id";
    private static final String DISPLAY_NAME = "displayName";
    private static final String URL = "url";
    private final String id;
    private final String displayName;
    private final String url;

    @JsonCreator
    private PipelineModel(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="url") @Nonnull String url) {
        this.id = Objects.requireNonNull(id, ID);
        this.displayName = Objects.requireNonNull(displayName, DISPLAY_NAME);
        this.url = Objects.requireNonNull(url, URL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineModel that = (PipelineModel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.url);
    }

    @JsonProperty(value="id")
    @Nonnull
    public String id() {
        return this.id;
    }

    @JsonProperty(value="displayName")
    @Nonnull
    public String displayName() {
        return this.displayName;
    }

    @JsonProperty(value="url")
    @Nonnull
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String url;

        @Nonnull
        public PipelineModel build() {
            return new PipelineModel(this.id, this.displayName, this.url);
        }

        @Nonnull
        public Builder id(@Nonnull String id) {
            this.id = Objects.requireNonNull(id, PipelineModel.ID);
            return this;
        }

        @Nonnull
        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, PipelineModel.DISPLAY_NAME);
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String url) {
            this.url = Objects.requireNonNull(url, PipelineModel.URL);
            return this;
        }
    }
}

