/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.deployment;

import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudResponse;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentKeyModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.RejectedDeploymentModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubmitDeploymentsResponse
extends JiraCloudResponse {
    private static final String ACCEPTED_DEPLOYMENTS = "acceptedDeployments";
    private static final String REJECTED_DEPLOYMENTS = "rejectedDeployments";
    private final ImmutableList<DeploymentKeyModel> acceptedDeployments;
    private final ImmutableList<RejectedDeploymentModel> rejectedDeployments;

    @JsonCreator
    public SubmitDeploymentsResponse(@JsonProperty(value="acceptedDeployments") List<DeploymentKeyModel> acceptedDeployments, @JsonProperty(value="rejectedDeployments") List<RejectedDeploymentModel> rejectedDeployments, @JsonProperty(value="unknownIssueKeys") Set<String> unknownIssueKeys) {
        super(unknownIssueKeys);
        this.acceptedDeployments = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(acceptedDeployments, new ArrayList())));
        this.rejectedDeployments = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(rejectedDeployments, new ArrayList())));
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper payloadStringHelper() {
        return MoreObjects.toStringHelper(SubmitDeploymentsResponse.class).add(ACCEPTED_DEPLOYMENTS, this.acceptedDeployments).add(REJECTED_DEPLOYMENTS, this.rejectedDeployments);
    }
}

