/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public abstract class DevInfoUser {
    public static final String AVATAR = "avatar";
    public static final String EMAIL = "email";
    public static final String NAME = "name";
    public static final String URL = "url";
    @JsonProperty(value="avatar")
    private final String avatar;
    @JsonProperty(value="email")
    private final String email;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="url")
    private final String url;

    protected DevInfoUser(Builder builder) {
        this.avatar = builder.avatar;
        this.email = builder.email;
        this.name = builder.name;
        this.url = builder.url;
    }

    @JsonProperty
    @Nullable
    public String avatar() {
        return this.avatar;
    }

    @JsonProperty
    @Nullable
    public String email() {
        return this.email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevInfoUser that = (DevInfoUser)o;
        return Objects.equals(this.avatar, that.avatar) && Objects.equals(this.email, that.email) && Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.avatar, this.email, this.name, this.url);
    }

    @JsonProperty
    @Nonnull
    public String name() {
        return this.name;
    }

    @JsonProperty
    @Nonnull
    public String url() {
        return this.url;
    }

    public static abstract class Builder<B extends Builder, T extends DevInfoUser> {
        private String avatar;
        private String email;
        private String name;
        private String url;

        @Nonnull
        public B avatar(@Nullable String avatar) {
            this.avatar = avatar;
            return this.self();
        }

        @Nonnull
        public abstract T build();

        @Nonnull
        public B email(@Nullable String email) {
            this.email = email;
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, DevInfoUser.NAME);
            return this.self();
        }

        @Nonnull
        public B url(@Nullable String url) {
            this.url = url;
            return this.self();
        }

        protected abstract B self();
    }
}

