/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo;

import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository.RepositoryModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DevInformation
extends JiraCloudRequest {
    private static final String PREVENT_TRANSITIONS = "preventTransitions";
    private static final String REPOSITORIES = "repositories";
    private final boolean preventTransitions;
    private final List<RepositoryModel> repositories;

    private DevInformation(@Nonnull Builder builder) {
        super(builder);
        Objects.requireNonNull(builder, "builder");
        this.preventTransitions = builder.preventTransitions;
        this.repositories = builder.repositories.build();
    }

    @JsonCreator
    private DevInformation(@JsonProperty(value="preventTransitions") boolean preventTransitions, @JsonProperty(value="properties") @Nullable Map<String, String> properties, @JsonProperty(value="providerMetadata") @Nullable Map<String, String> providerMetadata, @JsonProperty(value="repositories") @Nullable List<RepositoryModel> repositories) {
        super(properties, providerMetadata);
        this.preventTransitions = preventTransitions;
        this.repositories = repositories == null ? ImmutableList.of() : ImmutableList.copyOf(repositories);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DevInformation that = (DevInformation)o;
        return this.preventTransitions == that.preventTransitions && Objects.equals(this.repositories, that.repositories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.preventTransitions, this.repositories);
    }

    @JsonProperty(value="preventTransitions")
    public boolean preventTransitions() {
        return this.preventTransitions;
    }

    @JsonProperty(value="repositories")
    @Nonnull
    public List<RepositoryModel> repositories() {
        return this.repositories;
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper payloadStringHelper() {
        return MoreObjects.toStringHelper(DevInformation.class).add(PREVENT_TRANSITIONS, this.preventTransitions).add(REPOSITORIES, this.repositories);
    }

    public static class Builder
    extends JiraCloudRequest.AbstractBuilder<Builder, DevInformation> {
        private final ImmutableList.Builder<RepositoryModel> repositories = new ImmutableList.Builder();
        private boolean preventTransitions;

        @Override
        @Nonnull
        public DevInformation build() {
            return new DevInformation(this);
        }

        @Nonnull
        public Builder preventTransitions(boolean preventTransitions) {
            this.preventTransitions = preventTransitions;
            return this;
        }

        @Nonnull
        public Builder repositories(@Nonnull List<RepositoryModel> repositories) {
            this.repositories.addAll((Iterable)Objects.requireNonNull(repositories, DevInformation.REPOSITORIES));
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull RepositoryModel repository) {
            this.repositories.add((Object)Objects.requireNonNull(repository, "repository"));
            return this;
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }
    }
}

