/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class IsoDateFormatConverter {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("UTC"));

    public static String fromDate(Date date) {
        return FORMATTER.format(date.toInstant());
    }

    public static Date toDate(String isoDateString) {
        try {
            ZonedDateTime zonedDateTime = FORMATTER.parse((CharSequence)isoDateString, ZonedDateTime::from);
            return Date.from(zonedDateTime.toInstant());
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new IllegalStateException(String.format("Timestamp %s is not valid: %s", isoDateString, e));
        }
    }

    public static String millisToDateTime(long timeInMillis) {
        return FORMATTER.format(Instant.ofEpochMilli(timeInMillis));
    }

    public static Instant toInstant(String isoDateString) {
        return FORMATTER.parse((CharSequence)isoDateString, ZonedDateTime::from).toInstant();
    }
}

