/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch;

import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntityVisitor;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;

public class BranchModel
implements DevInfoEntity {
    private static final String CREATE_PULL_REQUEST_URL = "createPullRequestUrl";
    private static final String ID = "id";
    private static final String ISSUE_KEYS = "issueKeys";
    private static final String LAST_COMMIT = "lastCommit";
    private static final String NAME = "name";
    private static final String TIMESTAMP = "timestamp";
    private static final String UPDATE_SEQUENCE_ID = "updateSequenceId";
    private static final String URL = "url";
    private final String createPullRequestUrl;
    private final String id;
    private final Set<String> issueKeys;
    private final CommitModel lastCommit;
    private final String name;
    private final String timestamp;
    private final long updateSequenceId;
    private final String url;

    @JsonCreator
    private BranchModel(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="name") @Nonnull String name, @JsonProperty(value="issueKeys") @Nonnull Set<String> issueKeys, @JsonProperty(value="timestamp") @Nullable String timestamp, @JsonProperty(value="url") @Nonnull String url, @JsonProperty(value="lastCommit") @Nonnull CommitModel lastCommit, @JsonProperty(value="createPullRequestUrl") @Nullable String createPullRequestUrl, @JsonProperty(value="updateSequenceId") long updateSequenceId) {
        this.id = Objects.requireNonNull(id, ID);
        this.name = Objects.requireNonNull(name, NAME);
        this.issueKeys = Objects.requireNonNull(issueKeys, ISSUE_KEYS);
        this.timestamp = timestamp;
        this.url = Objects.requireNonNull(url, URL);
        this.lastCommit = Objects.requireNonNull(lastCommit, LAST_COMMIT);
        this.createPullRequestUrl = createPullRequestUrl;
        this.updateSequenceId = updateSequenceId;
    }

    @Override
    public void accept(DevInfoEntityVisitor visitor) {
        visitor.visit(this);
    }

    public static String convertBranchNameToJiraId(String branchName) {
        return Hex.encodeHexString((byte[])branchName.getBytes(StandardCharsets.UTF_8));
    }

    @JsonProperty(value="createPullRequestUrl")
    @Nullable
    public String createPullRequestUrl() {
        return this.createPullRequestUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchModel that = (BranchModel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.issueKeys, that.issueKeys) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.url, that.url) && Objects.equals(this.lastCommit, that.lastCommit) && Objects.equals(this.createPullRequestUrl, that.createPullRequestUrl) && Objects.equals(this.updateSequenceId, that.updateSequenceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.issueKeys, this.timestamp, this.url, this.lastCommit, this.createPullRequestUrl, this.updateSequenceId);
    }

    @Override
    @JsonProperty(value="id")
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="issueKeys")
    @Nonnull
    public Set<String> issueKeys() {
        return this.issueKeys;
    }

    @JsonProperty(value="lastCommit")
    @Nonnull
    public CommitModel lastCommit() {
        return this.lastCommit;
    }

    @JsonProperty(value="name")
    @Nonnull
    public String name() {
        return this.name;
    }

    @JsonProperty(value="timestamp")
    @Nullable
    public String timestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public DevInfoType type() {
        return DevInfoType.BRANCH;
    }

    @Override
    @JsonProperty(value="updateSequenceId")
    public long updateSequenceId() {
        return this.updateSequenceId;
    }

    @JsonProperty(value="url")
    @Nonnull
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private String createPullRequestUrl;
        private String id;
        private final ImmutableSet.Builder<String> issueKeys = new ImmutableSet.Builder();
        private CommitModel lastCommit;
        private String name;
        private String timestamp;
        private Long updateSequenceId;
        private String url;

        public BranchModel build() {
            return new BranchModel(this.id, this.name, (Set<String>)this.issueKeys.build(), this.timestamp, this.url, this.lastCommit, this.createPullRequestUrl, this.updateSequenceId);
        }

        @Nonnull
        public Builder createPullRequestUrl(@Nullable String createPullRequestUrl) {
            this.createPullRequestUrl = createPullRequestUrl;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String id) {
            this.id = Objects.requireNonNull(id, BranchModel.ID);
            return this;
        }

        @Nonnull
        public Builder issueKeys(@Nonnull Collection<String> issueKeys) {
            this.issueKeys.addAll((Iterable)Objects.requireNonNull(issueKeys, BranchModel.ISSUE_KEYS));
            return this;
        }

        @Nonnull
        public Builder lastCommit(@Nonnull CommitModel lastCommit) {
            this.lastCommit = Objects.requireNonNull(lastCommit, BranchModel.LAST_COMMIT);
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, BranchModel.NAME);
            return this;
        }

        @Nonnull
        public Builder timestamp(@Nullable String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Nonnull
        public Builder updateSequenceId(@Nonnull Long updateSequenceId) {
            this.updateSequenceId = Objects.requireNonNull(updateSequenceId, BranchModel.UPDATE_SEQUENCE_ID);
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String url) {
            this.url = Objects.requireNonNull(url, BranchModel.URL);
            return this;
        }
    }
}

