/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit;

import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntityVisitor;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.Author;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.File;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.Flag;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CommitModel
implements DevInfoEntity {
    private static final String AUTHOR = "author";
    private static final String AUTHOR_TIMESTAMP = "authorTimestamp";
    private static final String DISPLAY_ID = "displayId";
    private static final String FILES = "files";
    private static final String FILE_COUNT = "fileCount";
    private static final String FLAGS = "flags";
    private static final String HASH = "hash";
    private static final String ID = "id";
    private static final String ISSUE_KEYS = "issueKeys";
    private static final String MESSAGE = "message";
    private static final String TIMESTAMP = "timestamp";
    private static final String UPDATE_SEQUENCE_ID = "updateSequenceId";
    private static final String URL = "url";
    private final Author author;
    private final String authorTimestamp;
    private final String displayId;
    private final int fileCount;
    private final List<File> files;
    private final Set<Flag> flags;
    private final String hash;
    private final String id;
    private final Set<String> issueKeys;
    private final String message;
    private final String timestamp;
    private final long updateSequenceId;
    private final String url;

    @JsonCreator
    public CommitModel(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="hash") @Nonnull String hash, @JsonProperty(value="message") @Nonnull String message, @JsonProperty(value="issueKeys") @Nonnull Set<String> issueKeys, @JsonProperty(value="timestamp") @Nullable String timestamp, @JsonProperty(value="url") @Nonnull String url, @JsonProperty(value="displayId") @Nonnull String displayId, @JsonProperty(value="authorTimestamp") @Nullable String authorTimestamp, @JsonProperty(value="author") @Nonnull Author author, @JsonProperty(value="fileCount") int fileCount, @JsonProperty(value="flags") @Nullable Set<Flag> flags, @JsonProperty(value="files") @Nullable List<File> files, @JsonProperty(value="updateSequenceId") long updateSequenceId) {
        this.id = Objects.requireNonNull(id, ID);
        this.hash = Objects.requireNonNull(hash, HASH);
        this.message = Objects.requireNonNull(message, MESSAGE);
        this.timestamp = timestamp;
        this.url = Objects.requireNonNull(url, URL);
        this.displayId = Objects.requireNonNull(displayId, DISPLAY_ID);
        this.authorTimestamp = Objects.requireNonNull(authorTimestamp, AUTHOR_TIMESTAMP);
        this.author = Objects.requireNonNull(author, AUTHOR);
        this.fileCount = fileCount;
        this.flags = flags == null ? Collections.emptySet() : flags;
        this.files = files == null ? Collections.emptyList() : files;
        this.issueKeys = Objects.requireNonNull(issueKeys, ISSUE_KEYS);
        this.updateSequenceId = updateSequenceId;
    }

    @Override
    public void accept(DevInfoEntityVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="author")
    public Author author() {
        return this.author;
    }

    @JsonProperty(value="authorTimestamp")
    public String authorTimestamp() {
        return this.authorTimestamp;
    }

    @JsonProperty(value="displayId")
    public String displayId() {
        return this.displayId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitModel commitTO = (CommitModel)o;
        return this.fileCount == commitTO.fileCount && Objects.equals(this.id, commitTO.id) && Objects.equals(this.hash, commitTO.hash) && Objects.equals(this.message, commitTO.message) && Objects.equals(this.issueKeys, commitTO.issueKeys) && Objects.equals(this.timestamp, commitTO.timestamp) && Objects.equals(this.displayId, commitTO.displayId) && Objects.equals(this.url, commitTO.url) && Objects.equals(this.authorTimestamp, commitTO.authorTimestamp) && Objects.equals(this.author, commitTO.author) && Objects.equals(this.flags, commitTO.flags) && Objects.equals(this.files, commitTO.files) && Objects.equals(this.updateSequenceId, commitTO.updateSequenceId);
    }

    @JsonProperty(value="fileCount")
    public int fileCount() {
        return this.fileCount;
    }

    @JsonProperty(value="files")
    public List<File> files() {
        return this.files;
    }

    @JsonProperty(value="flags")
    public Set<Flag> flags() {
        return this.flags;
    }

    @JsonProperty(value="hash")
    public String hash() {
        return this.hash;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.hash, this.message, this.issueKeys, this.timestamp, this.displayId, this.url, this.authorTimestamp, this.author, this.fileCount, this.flags, this.files, this.updateSequenceId);
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="issueKeys")
    public Set<String> issueKeys() {
        return this.issueKeys;
    }

    @JsonProperty(value="message")
    public String message() {
        return this.message;
    }

    @JsonProperty(value="timestamp")
    public String timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return MoreObjects.toStringHelper(CommitModel.class).add(ID, (Object)this.id).add(HASH, (Object)this.hash).add(MESSAGE, (Object)this.message).add(ISSUE_KEYS, this.issueKeys).add(TIMESTAMP, (Object)this.timestamp).add(DISPLAY_ID, (Object)this.displayId).add(URL, (Object)this.url).add(AUTHOR_TIMESTAMP, (Object)this.authorTimestamp).add(AUTHOR, (Object)this.author).add(FILE_COUNT, this.fileCount).add(FLAGS, this.flags).add(UPDATE_SEQUENCE_ID, this.updateSequenceId).toString();
    }

    @Override
    @Nonnull
    public DevInfoType type() {
        return DevInfoType.COMMIT;
    }

    @Override
    @JsonProperty(value="updateSequenceId")
    public long updateSequenceId() {
        return this.updateSequenceId;
    }

    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private Author author;
        private String authorTimestamp;
        private String displayId;
        private int fileCount;
        private List<File> files;
        private Set<Flag> flags;
        private String hash;
        private String id;
        private final ImmutableSet.Builder<String> issueKeys = new ImmutableSet.Builder();
        private String message;
        private String timestamp;
        private Long updateSequenceId;
        private String url;

        public Builder author(Author author) {
            this.author = author;
            return this;
        }

        public Builder authorTimestamp(String authorTimestamp) {
            this.authorTimestamp = authorTimestamp;
            return this;
        }

        public CommitModel build() {
            return new CommitModel(this.id, this.hash, this.message, (Set<String>)this.issueKeys.build(), this.timestamp, this.url, this.displayId, this.authorTimestamp, this.author, this.fileCount, this.flags, this.files, this.updateSequenceId);
        }

        public Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public Builder fileCount(int fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public Builder files(List<File> files) {
            this.files = files;
            return this;
        }

        public Builder flags(Set<Flag> flags) {
            this.flags = flags;
            return this;
        }

        public Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder issueKeys(Collection<String> issueKeys) {
            this.issueKeys.addAll((Iterable)Objects.requireNonNull(issueKeys, CommitModel.ISSUE_KEYS));
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder updateSequenceId(Long updateSequenceId) {
            this.updateSequenceId = updateSequenceId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }
}

