/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit;

import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitFileChangeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class File {
    private static final String CHANGE_TYPE = "changeType";
    private static final String LINES_ADDED = "linesAdded";
    private static final String LINES_REMOVED = "linesRemoved";
    private static final String PATH = "path";
    private static final String URL = "url";
    private final CommitFileChangeType changeType;
    private final int linesAdded;
    private final int linesRemoved;
    private final String path;
    private final String url;

    @JsonCreator
    public File(@JsonProperty(value="path") String path, @JsonProperty(value="url") String url, @JsonProperty(value="changeType") CommitFileChangeType changeType, @JsonProperty(value="linesAdded") int linesAdded, @JsonProperty(value="linesRemoved") int linesRemoved) {
        this.path = Objects.requireNonNull(path);
        this.url = Objects.requireNonNull(url);
        this.changeType = Objects.requireNonNull(changeType);
        this.linesAdded = linesAdded;
        this.linesRemoved = linesRemoved;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="changeType")
    public CommitFileChangeType changeType() {
        return this.changeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        return this.linesAdded == file.linesAdded && this.linesRemoved == file.linesRemoved && Objects.equals(this.path, file.path) && Objects.equals(this.url, file.url) && this.changeType == file.changeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.url, this.changeType, this.linesAdded, this.linesRemoved});
    }

    @JsonProperty(value="linesAdded")
    public int linesAdded() {
        return this.linesAdded;
    }

    @JsonProperty(value="linesRemoved")
    public int linesRemoved() {
        return this.linesRemoved;
    }

    @JsonProperty(value="path")
    public String path() {
        return this.path;
    }

    public String toString() {
        return "FileTOImpl{path='" + this.path + "', url='" + this.url + "', changeType=" + String.valueOf((Object)this.changeType) + ", linesAdded=" + this.linesAdded + ", linesRemoved=" + this.linesRemoved + "}";
    }

    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private CommitFileChangeType changeType;
        private int linesAdded;
        private int linesRemoved;
        private String path;
        private String url;

        public File build() {
            return new File(this.path, this.url, this.changeType, this.linesAdded, this.linesRemoved);
        }

        public Builder changeType(CommitFileChangeType changeType) {
            this.changeType = changeType;
            return this;
        }

        public Builder linesAdded(int linesAdded) {
            this.linesAdded = linesAdded;
            return this;
        }

        public Builder linesRemoved(int linesRemoved) {
            this.linesRemoved = linesRemoved;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }
}

