/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull;

import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntityVisitor;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.Author;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.Reviewer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class PullRequestModel
implements DevInfoEntity {
    private static final String ID = "id";
    private static final String AUTHOR = "author";
    private static final String COMMENT_COUNT = "commentCount";
    private static final String DESTINATION_BRANCH = "destinationBranch";
    private static final String DISPLAY_ID = "displayId";
    private static final String ISSUE_KEYS = "issueKeys";
    private static final String LAST_UPDATE = "lastUpdate";
    private static final String REVIEWERS = "reviewers";
    private static final String SOURCE_BRANCH = "sourceBranch";
    private static final String SOURCE_BRANCH_URL = "sourceBranchUrl";
    private static final String STATUS = "status";
    private static final String TITLE = "title";
    private static final String UPDATE_SEQUENCE_ID = "updateSequenceId";
    private static final String URL = "url";
    private final String id;
    private final Author author;
    private final Integer commentCount;
    private final String destinationBranch;
    private final String displayId;
    private final Set<String> issueKeys;
    private final String lastUpdate;
    private final Set<Reviewer> reviewers;
    private final String sourceBranch;
    private final String sourceBranchUrl;
    private final PullRequestState status;
    private final String title;
    private final long updateSequenceId;
    private final String url;

    @JsonCreator
    private PullRequestModel(@JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="author") @Nonnull Author author, @JsonProperty(value="commentCount") @Nullable Integer commentCount, @JsonProperty(value="destinationBranch") @Nonnull String destinationBranch, @JsonProperty(value="displayId") @Nonnull String displayId, @JsonProperty(value="issueKeys") @Nonnull Set<String> issueKeys, @JsonProperty(value="lastUpdate") @Nonnull String lastUpdate, @JsonProperty(value="reviewers") @Nonnull Set<Reviewer> reviewers, @JsonProperty(value="sourceBranch") @Nonnull String sourceBranch, @JsonProperty(value="sourceBranchUrl") @Nonnull String sourceBranchUrl, @JsonProperty(value="status") @Nonnull PullRequestState status, @JsonProperty(value="title") @Nonnull String title, @JsonProperty(value="updateSequenceId") long updateSequenceId, @JsonProperty(value="url") @Nonnull String url) {
        this.id = Objects.requireNonNull(id, ID);
        this.author = Objects.requireNonNull(author, AUTHOR);
        this.commentCount = commentCount;
        this.destinationBranch = Objects.requireNonNull(destinationBranch, DESTINATION_BRANCH);
        this.displayId = Objects.requireNonNull(displayId, DISPLAY_ID);
        this.issueKeys = Objects.requireNonNull(issueKeys, ISSUE_KEYS);
        this.lastUpdate = Objects.requireNonNull(lastUpdate, LAST_UPDATE);
        this.reviewers = Objects.requireNonNull(reviewers, REVIEWERS);
        this.sourceBranch = Objects.requireNonNull(sourceBranch, SOURCE_BRANCH);
        this.sourceBranchUrl = Objects.requireNonNull(sourceBranchUrl, SOURCE_BRANCH_URL);
        this.status = Objects.requireNonNull(status, STATUS);
        this.title = Objects.requireNonNull(title, TITLE);
        this.updateSequenceId = updateSequenceId;
        this.url = Objects.requireNonNull(url, URL);
    }

    @Override
    public void accept(DevInfoEntityVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequestModel that = (PullRequestModel)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.author, that.author) && Objects.equals(this.commentCount, that.commentCount) && Objects.equals(this.destinationBranch, that.destinationBranch) && Objects.equals(this.displayId, that.displayId) && Objects.equals(this.issueKeys, that.issueKeys) && Objects.equals(this.lastUpdate, that.lastUpdate) && Objects.equals(this.reviewers, that.reviewers) && Objects.equals(this.sourceBranch, that.sourceBranch) && Objects.equals(this.sourceBranchUrl, that.sourceBranchUrl) && Objects.equals(this.status, that.status) && Objects.equals(this.title, that.title) && Objects.equals(this.updateSequenceId, that.updateSequenceId) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.author, this.commentCount, this.destinationBranch, this.displayId, this.issueKeys, this.lastUpdate, this.reviewers, this.sourceBranch, this.sourceBranchUrl, this.status, this.title, this.updateSequenceId, this.url);
    }

    @Override
    @Nonnull
    public DevInfoType type() {
        return DevInfoType.PULL_REQUEST;
    }

    @Override
    @JsonProperty(value="id")
    @Nonnull
    public String id() {
        return this.id;
    }

    @JsonProperty(value="author")
    @Nonnull
    public Author author() {
        return this.author;
    }

    @JsonProperty(value="commentCount")
    @Nullable
    public Integer commentCount() {
        return this.commentCount;
    }

    @JsonProperty(value="destinationBranch")
    @Nonnull
    public String destinationBranch() {
        return this.destinationBranch;
    }

    @JsonProperty(value="displayId")
    @Nonnull
    public String displayId() {
        return this.displayId;
    }

    @Override
    @JsonProperty(value="issueKeys")
    @Nonnull
    public Set<String> issueKeys() {
        return this.issueKeys;
    }

    @JsonProperty(value="lastUpdate")
    @Nonnull
    public String lastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="reviewers")
    @Nullable
    public Set<Reviewer> reviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="sourceBranch")
    @Nonnull
    public String sourceBranch() {
        return this.sourceBranch;
    }

    @JsonProperty(value="sourceBranchUrl")
    @Nullable
    public String sourceBranchUrl() {
        return this.sourceBranchUrl;
    }

    @JsonProperty(value="status")
    @Nonnull
    public PullRequestState status() {
        return this.status;
    }

    @JsonProperty(value="title")
    @Nonnull
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="updateSequenceId")
    public long updateSequenceId() {
        return this.updateSequenceId;
    }

    @JsonProperty(value="url")
    @Nonnull
    public String url() {
        return this.url;
    }

    public static final class Builder {
        private String id;
        private Author author;
        private Integer commentCount;
        private String destinationBranch;
        private String displayId;
        private final ImmutableSet.Builder<String> issueKeys = new ImmutableSet.Builder();
        private String lastUpdate;
        private final ImmutableSet.Builder<Reviewer> reviewers = new ImmutableSet.Builder();
        private String sourceBranch;
        private String sourceBranchUrl;
        private PullRequestState status;
        private String title;
        private Long updateSequenceId;
        private String url;

        public PullRequestModel build() {
            return new PullRequestModel(this.id, this.author, this.commentCount, this.destinationBranch, this.displayId, (Set<String>)this.issueKeys.build(), this.lastUpdate, (Set<Reviewer>)this.reviewers.build(), this.sourceBranch, this.sourceBranchUrl, this.status, this.title, this.updateSequenceId, this.url);
        }

        @Nonnull
        public Builder id(@Nonnull String value) {
            this.id = Objects.requireNonNull(value, PullRequestModel.ID);
            return this;
        }

        @Nonnull
        public Builder author(@Nonnull Author value) {
            this.author = Objects.requireNonNull(value, PullRequestModel.AUTHOR);
            return this;
        }

        @Nonnull
        public Builder commentCount(@Nullable Integer value) {
            this.commentCount = value;
            return this;
        }

        @Nonnull
        public Builder destinationBranch(@Nonnull String value) {
            this.destinationBranch = Objects.requireNonNull(value, PullRequestModel.DESTINATION_BRANCH);
            return this;
        }

        @Nonnull
        public Builder displayId(@Nonnull String value) {
            this.displayId = Objects.requireNonNull(value, PullRequestModel.DISPLAY_ID);
            return this;
        }

        @Nonnull
        public Builder issueKeys(@Nonnull Set<String> values) {
            this.issueKeys.addAll((Iterable)Objects.requireNonNull(values, PullRequestModel.ISSUE_KEYS));
            return this;
        }

        @Nonnull
        public Builder lastUpdate(@Nonnull String value) {
            this.lastUpdate = Objects.requireNonNull(value, PullRequestModel.LAST_UPDATE);
            return this;
        }

        @Nonnull
        public Builder reviewers(@Nullable Set<Reviewer> values) {
            if (values != null && !values.isEmpty()) {
                this.reviewers.addAll(values);
            }
            return this;
        }

        @Nonnull
        public Builder sourceBranch(@Nonnull String value) {
            this.sourceBranch = Objects.requireNonNull(value, PullRequestModel.SOURCE_BRANCH);
            return this;
        }

        @Nonnull
        public Builder sourceBranchUrl(@Nonnull String value) {
            this.sourceBranchUrl = Objects.requireNonNull(value, PullRequestModel.SOURCE_BRANCH_URL);
            return this;
        }

        @Nonnull
        public Builder status(@Nonnull PullRequestState value) {
            this.status = Objects.requireNonNull(value, PullRequestModel.STATUS);
            return this;
        }

        @Nonnull
        public Builder title(@Nonnull String value) {
            this.title = Objects.requireNonNull(value, PullRequestModel.TITLE);
            return this;
        }

        @Nonnull
        public Builder updateSequenceId(@Nonnull Long value) {
            this.updateSequenceId = Objects.requireNonNull(value, PullRequestModel.UPDATE_SEQUENCE_ID);
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = Objects.requireNonNull(value, PullRequestModel.URL);
            return this;
        }
    }
}

