/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public final class Reviewer
extends DevInfoUser {
    public static final String APPROVAL_STATUS = "approvalStatus";
    @JsonProperty(value="approvalStatus")
    private final PullRequestParticipantStatus approvalStatus;

    private Reviewer(Builder builder) {
        super(builder);
        this.approvalStatus = builder.approvalStatus;
    }

    @JsonProperty
    @Nullable
    public PullRequestParticipantStatus approvalStatus() {
        return this.approvalStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reviewer that = (Reviewer)o;
        return super.equals(that) && Objects.equals(this.approvalStatus, that.approvalStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.approvalStatus);
    }

    public String toString() {
        return "Reviewer {approvalStatus='" + String.valueOf(this.approvalStatus()) + "', avatar='" + this.avatar() + "', email='" + this.email() + "', name='" + this.name() + "', url='" + this.url() + "'}";
    }

    public static final class Builder
    extends DevInfoUser.Builder<Builder, Reviewer> {
        private PullRequestParticipantStatus approvalStatus;

        @Override
        @Nonnull
        public Reviewer build() {
            return new Reviewer(this);
        }

        @Nonnull
        public Builder approvalStatus(@Nonnull PullRequestParticipantStatus value) {
            this.approvalStatus = Objects.requireNonNull(value, Reviewer.APPROVAL_STATUS);
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

