/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nullable;
import java.util.List;

public final class AcceptedRepositoryIds {
    private final List<String> branches;
    private final List<String> commits;
    private final List<String> pullRequests;

    @JsonCreator
    private AcceptedRepositoryIds(@JsonProperty(value="branches") List<String> branches, @JsonProperty(value="commits") List<String> commits, @JsonProperty(value="pullRequests") List<String> pullRequests) {
        this.branches = ImmutableList.copyOf(branches);
        this.commits = ImmutableList.copyOf(commits);
        this.pullRequests = ImmutableList.copyOf(pullRequests);
    }

    public List<String> branches() {
        return this.branches;
    }

    public List<String> commits() {
        return this.commits;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AcceptedRepositoryIds && this.equalTo((AcceptedRepositoryIds)another);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.branches, this.commits, this.pullRequests});
    }

    public List<String> pullRequests() {
        return this.pullRequests;
    }

    public String toString() {
        return MoreObjects.toStringHelper(AcceptedRepositoryIds.class).omitNullValues().add("branches", this.branches).add("commits", this.commits).add("pullRequests", this.pullRequests).toString();
    }

    private boolean equalTo(AcceptedRepositoryIds another) {
        return this.branches.equals(another.branches) && this.commits.equals(another.commits) && this.pullRequests.equals(another.pullRequests);
    }
}

