/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository;

import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.error.EntityError;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.error.ErrorMessages;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public final class RepositoryErrors {
    private final List<EntityError> branches;
    private final List<EntityError> commits;
    private final List<ErrorMessages> errorMessages;
    private final List<EntityError> pullRequests;

    @JsonCreator
    public RepositoryErrors(@JsonProperty(value="branches") List<EntityError> branches, @JsonProperty(value="commits") List<EntityError> commits, @JsonProperty(value="pullRequests") List<EntityError> pullRequests, @JsonProperty(value="errorMessages") List<ErrorMessages> errorMessages) {
        this.branches = ImmutableList.copyOf(branches);
        this.commits = ImmutableList.copyOf(commits);
        this.pullRequests = ImmutableList.copyOf(pullRequests);
        this.errorMessages = ImmutableList.copyOf(errorMessages);
    }

    public List<EntityError> branches() {
        return this.branches;
    }

    public List<EntityError> commits() {
        return this.commits;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RepositoryErrors && this.equalTo((RepositoryErrors)another);
    }

    public List<ErrorMessages> errorMessages() {
        return this.errorMessages;
    }

    public int hashCode() {
        return Objects.hash(this.branches, this.commits, this.pullRequests, this.errorMessages);
    }

    public List<EntityError> pullRequests() {
        return this.pullRequests;
    }

    public String toString() {
        return MoreObjects.toStringHelper(RepositoryErrors.class).omitNullValues().add("branches", this.branches).add("commits", this.commits).add("pullRequests", this.pullRequests).add("errorMessages", this.errorMessages).toString();
    }

    private boolean equalTo(RepositoryErrors another) {
        return this.branches.equals(another.branches) && this.commits.equals(another.commits) && this.pullRequests.equals(another.pullRequests) && this.errorMessages.equals(another.errorMessages);
    }
}

