/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository;

import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.IdBasedEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.SequencedEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch.BranchModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.PullRequestModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RepositoryModel
implements SequencedEntity,
IdBasedEntity {
    public static final String AVATAR = "avatar";
    public static final String AVATAR_DESCRIPTION = "avatarDescription";
    public static final String BRANCHES = "branches";
    public static final String COMMITS = "commits";
    public static final String DESCRIPTION = "description";
    public static final String FORK_OF = "forkOf";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String UPDATE_SEQUENCE_ID = "updateSequenceId";
    public static final String PULL_REQUESTS = "pullRequests";
    public static final String URL = "url";
    private final String avatar;
    private final List<BranchModel> branches;
    private final List<CommitModel> commits;
    private final String description;
    private final String forkOf;
    private final String id;
    private final String name;
    private final List<PullRequestModel> pullRequests;
    private final long updateSequenceId;
    private final String url;

    @JsonCreator
    private RepositoryModel(@JsonProperty(value="url") @Nonnull String url, @JsonProperty(value="name") @Nonnull String name, @JsonProperty(value="avatar") @Nonnull String avatar, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="forkOf") @Nullable String forkOf, @JsonProperty(value="branches") @Nonnull List<BranchModel> branches, @JsonProperty(value="commits") @Nonnull List<CommitModel> commits, @JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="pullRequests") @Nonnull List<PullRequestModel> pullRequests, @JsonProperty(value="updateSequenceId") long updateSequenceId) {
        this.id = Objects.requireNonNull(id, ID);
        this.url = Objects.requireNonNull(url, URL);
        this.name = Objects.requireNonNull(name, NAME);
        this.avatar = avatar;
        this.description = description;
        this.forkOf = forkOf;
        this.branches = branches;
        this.commits = commits;
        this.pullRequests = pullRequests;
        this.updateSequenceId = updateSequenceId;
    }

    @JsonProperty
    @Nullable
    public String avatar() {
        return this.avatar;
    }

    @JsonProperty
    @Nonnull
    public List<BranchModel> branches() {
        return this.branches;
    }

    @JsonProperty
    @Nonnull
    public List<CommitModel> commits() {
        return this.commits;
    }

    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    public Set<DevInfoEntity> entities() {
        return Stream.of(this.branches(), this.commits(), this.pullRequests()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryModel that = (RepositoryModel)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.name, that.name) && Objects.equals(this.avatar, that.avatar) && Objects.equals(this.description, that.description) && Objects.equals(this.forkOf, that.forkOf) && Objects.equals(this.branches, that.branches) && Objects.equals(this.commits, that.commits) && Objects.equals(this.pullRequests, that.pullRequests) && Objects.equals(this.id, that.id) && Objects.equals(this.updateSequenceId, that.updateSequenceId);
    }

    @JsonProperty
    @Nullable
    public String forkOf() {
        return this.forkOf;
    }

    public int hashCode() {
        return Objects.hash(this.url, this.name, this.avatar, this.description, this.forkOf, this.branches, this.pullRequests, this.id, this.updateSequenceId);
    }

    @Override
    @JsonProperty
    @Nonnull
    public String id() {
        return this.id;
    }

    @JsonProperty
    @Nonnull
    public String name() {
        return this.name;
    }

    @JsonProperty
    @Nonnull
    public List<PullRequestModel> pullRequests() {
        return this.pullRequests;
    }

    public String toString() {
        return MoreObjects.toStringHelper(RepositoryModel.class).add(URL, (Object)this.url).add(NAME, (Object)this.name).add(AVATAR, (Object)this.avatar).add(AVATAR_DESCRIPTION, (Object)this.description).add(DESCRIPTION, (Object)this.description).add(FORK_OF, (Object)this.forkOf).add(BRANCHES, this.branches).add(COMMITS, this.commits).add(PULL_REQUESTS, this.pullRequests).add(ID, (Object)this.id).add(UPDATE_SEQUENCE_ID, this.updateSequenceId).toString();
    }

    @Override
    @JsonProperty
    public long updateSequenceId() {
        return this.updateSequenceId;
    }

    @JsonProperty
    @Nullable
    public String url() {
        return this.url;
    }

    public static class Builder {
        private String avatar;
        private final ImmutableList.Builder<BranchModel> branches = ImmutableList.builder();
        private final ImmutableList.Builder<CommitModel> commits = ImmutableList.builder();
        private final ImmutableList.Builder<PullRequestModel> pullRequests = ImmutableList.builder();
        private String description;
        private String forkOf;
        private String id;
        private String name;
        private Long updateSequenceId;
        private String url;

        public RepositoryModel build() {
            return new RepositoryModel(this.url, this.name, this.avatar, this.description, this.forkOf, (List<BranchModel>)this.branches.build(), (List<CommitModel>)this.commits.build(), this.id, (List<PullRequestModel>)this.pullRequests.build(), this.updateSequenceId);
        }

        @Nonnull
        public Builder avatar(@Nullable String avatar) {
            this.avatar = avatar;
            return this;
        }

        @Nonnull
        public Builder branch(@Nonnull BranchModel branch) {
            this.branches.add((Object)Objects.requireNonNull(branch));
            return this;
        }

        @Nonnull
        public Builder commit(@Nonnull CommitModel commit) {
            this.commits.add((Object)Objects.requireNonNull(commit));
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder forkOf(@Nullable String forkOf) {
            this.forkOf = forkOf;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String id) {
            this.id = Objects.requireNonNull(id, RepositoryModel.ID);
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.name = Objects.requireNonNull(name, RepositoryModel.NAME);
            return this;
        }

        @Nonnull
        public Builder pullRequest(@Nonnull PullRequestModel pullRequest) {
            this.pullRequests.add((Object)Objects.requireNonNull(pullRequest));
            return this;
        }

        @Nonnull
        public Builder updateSequenceId(@Nonnull Long updateSequenceId) {
            this.updateSequenceId = Objects.requireNonNull(updateSequenceId, RepositoryModel.UPDATE_SEQUENCE_ID);
            return this;
        }

        @Nonnull
        public Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }
    }
}

