/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudPermissionsCache;
import com.atlassian.stash.internal.jira.cloud.client.exception.AccessTokenFetchException;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.JiraSitePermissionsService;
import com.atlassian.stash.internal.jira.http.client.exception.HttpClientException;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraSitePermissionsService
implements JiraSitePermissionsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraSitePermissionsService.class);
    private final I18nService i18nService;
    private final JiraCloudPermissionsCache jiraCloudPermissionsCache;

    public DefaultJiraSitePermissionsService(I18nService i18nService, JiraCloudPermissionsCache jiraCloudPermissionsCache) {
        this.i18nService = i18nService;
        this.jiraCloudPermissionsCache = jiraCloudPermissionsCache;
    }

    @Override
    @Nonnull
    public Set<JiraCloudOauthPermission> getPermissions(@Nonnull JiraSiteConfig jiraSiteConfig) {
        return this.getPermissions(jiraSiteConfig, false);
    }

    @Override
    @Nonnull
    public Set<JiraCloudOauthPermission> refreshPermissions(@Nonnull JiraSiteConfig jiraSiteConfig) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        return this.getPermissions(jiraSiteConfig, true);
    }

    private Set<JiraCloudOauthPermission> getPermissions(JiraSiteConfig jiraSiteConfig, boolean refreshCache) {
        if (refreshCache) {
            this.jiraCloudPermissionsCache.invalidate(jiraSiteConfig);
        }
        try {
            Set<JiraCloudOauthPermission> permissions = this.jiraCloudPermissionsCache.get(jiraSiteConfig);
            log.debug("Permissions for jira site: [name: {}, client id: {}] refreshed with Oauth credentials as follows - {}", new Object[]{jiraSiteConfig.getName(), jiraSiteConfig.getClientId(), permissions});
            return permissions;
        }
        catch (AccessTokenFetchException | HttpClientException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.permissions.error", new Object[]{e.getMessage()});
            throw new IllegalEntityStateException(message);
        }
    }
}

