/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config;

import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class JiraSiteConfigConnectionUpdateRequest {
    private final int id;
    private final String message;
    private final ConnectionStatus status;

    private JiraSiteConfigConnectionUpdateRequest(int id, ConnectionStatus status, String message) {
        this.id = id;
        this.status = Objects.requireNonNull(status, "status");
        this.message = Objects.requireNonNull(message, "message");
    }

    public static JiraSiteConfigConnectionUpdateRequest updateForSuccess(int id) {
        return new JiraSiteConfigConnectionUpdateRequest(id, ConnectionStatus.CONNECTED, "");
    }

    public static JiraSiteConfigConnectionUpdateRequest updateForFailure(int id, ConnectionStatus connectionStatus, String message) {
        Preconditions.checkArgument((connectionStatus != ConnectionStatus.CONNECTED ? 1 : 0) != 0, (Object)("Error connection status can not be " + String.valueOf((Object)ConnectionStatus.CONNECTED)));
        return new JiraSiteConfigConnectionUpdateRequest(id, connectionStatus, message);
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public ConnectionStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("status", (Object)this.status).add("message", (Object)this.message).toString();
    }
}

