/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config;

import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleJiraSiteConfig
implements JiraSiteConfig {
    private final int id;
    private final String clientId;
    private final String clientSecret;
    private final String cloudId;
    private final ConnectionStatus connectionStatus;
    private final String connectionErrorDescription;
    private final String name;
    private final String url;

    public SimpleJiraSiteConfig(Builder builder) {
        this.id = builder.id;
        this.clientId = Objects.requireNonNull(builder.clientId, "clientId");
        this.clientSecret = Objects.requireNonNull(builder.clientSecret, "clientSecret");
        this.cloudId = Objects.requireNonNull(builder.cloudId, "cloudId");
        this.connectionStatus = Objects.requireNonNull(builder.connectionStatus, "connectionStatus");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.url = Objects.requireNonNull(builder.url, "url");
        this.connectionErrorDescription = builder.connectionErrorMessage;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nonnull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nonnull
    public String getCloudId() {
        return this.cloudId;
    }

    @Override
    @Nonnull
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    @Nullable
    public String getConnectionErrorDescription() {
        return this.connectionErrorDescription;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleJiraSiteConfig that = (SimpleJiraSiteConfig)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static class Builder {
        private int id;
        private String clientId;
        private String clientSecret;
        private String cloudId;
        private ConnectionStatus connectionStatus;
        private String connectionErrorMessage;
        private String name;
        private String url;

        public SimpleJiraSiteConfig build() {
            return new SimpleJiraSiteConfig(this);
        }

        public Builder id(int value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder clientId(@Nonnull String value) {
            this.clientId = Objects.requireNonNull(value, "clientId");
            return this;
        }

        @Nonnull
        public Builder clientSecret(@Nonnull String value) {
            this.clientSecret = Objects.requireNonNull(value, "clientSecret");
            return this;
        }

        @Nonnull
        public Builder cloudId(@Nonnull String value) {
            this.cloudId = Objects.requireNonNull(value, "cloudId");
            return this;
        }

        @Nonnull
        public Builder connectionStatus(@Nonnull ConnectionStatus value) {
            this.connectionStatus = Objects.requireNonNull(value, "connectionStatus");
            return this;
        }

        @Nonnull
        public Builder connectionErrorDescription(@Nullable String errorDescription) {
            this.connectionErrorMessage = errorDescription;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = Objects.requireNonNull(value, "url");
            return this;
        }
    }
}

