/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigConnectionUpdateRequest;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigRequest;
import com.atlassian.stash.internal.jira.cloud.config.dao.AoJiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.dao.JiraSiteConfigDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Optional;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class AoJiraSiteConfigDao
extends AbstractAoDao
implements JiraSiteConfigDao {
    @VisibleForTesting
    AoJiraSiteConfigDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoJiraSiteConfig create(@Nonnull JiraSiteConfigRequest jiraSiteConfigRequest, @Nonnull String cloudId, @Nonnull ConnectionStatus connectionStatus) {
        ImmutableMap params = ImmutableMap.builder().put((Object)"CLIENT_ID", (Object)jiraSiteConfigRequest.getClientId()).put((Object)"CLIENT_SECRET", (Object)jiraSiteConfigRequest.getClientSecret()).put((Object)"CLOUD_ID", (Object)cloudId).put((Object)"CONNECTION_STATUS", (Object)connectionStatus).put((Object)"JIRA_URL", (Object)jiraSiteConfigRequest.getUrl()).put((Object)"NAME", (Object)jiraSiteConfigRequest.getName()).build();
        return (AoJiraSiteConfig)this.ao.create(AoJiraSiteConfig.class, (Map)params);
    }

    @Override
    public void deleteById(int id) {
        this.ao.delete(new RawEntity[]{this.ao.get(AoJiraSiteConfig.class, (Object)id)});
    }

    @Override
    public boolean hasAnySitesConfigured() {
        return this.ao.count(AoJiraSiteConfig.class) > 0;
    }

    @Override
    @Nonnull
    public Page<AoJiraSiteConfig> getAll(@Nonnull PageRequest pageRequest) {
        Query query = AoUtils.newQuery((String[])AoJiraSiteConfig.ALL_COLUMNS).order("NAME asc");
        return this.pageQuery(AoJiraSiteConfig.class, query, pageRequest);
    }

    @Override
    @Nonnull
    public Optional<AoJiraSiteConfig> getByClientId(String clientId) {
        AoJiraSiteConfig[] aoJiraSiteConfigs = (AoJiraSiteConfig[])this.ao.find(AoJiraSiteConfig.class, "CLIENT_ID = ?", new Object[]{clientId});
        if (aoJiraSiteConfigs.length == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(aoJiraSiteConfigs[0]);
    }

    @Override
    @Nonnull
    public Optional<AoJiraSiteConfig> getById(int id) {
        return Optional.ofNullable((AoJiraSiteConfig)this.ao.get(AoJiraSiteConfig.class, (Object)id));
    }

    @Override
    @Nonnull
    public AoJiraSiteConfig update(int id, @Nonnull JiraSiteConfigRequest jiraSiteConfigRequest, @Nonnull String cloudId, @Nonnull ConnectionStatus connectionStatus) {
        AoJiraSiteConfig aoJiraSiteConfig = (AoJiraSiteConfig)this.ao.get(AoJiraSiteConfig.class, (Object)id);
        if (aoJiraSiteConfig != null) {
            aoJiraSiteConfig.setClientId(jiraSiteConfigRequest.getClientId());
            aoJiraSiteConfig.setClientSecret(jiraSiteConfigRequest.getClientSecret());
            aoJiraSiteConfig.setCloudId(cloudId);
            aoJiraSiteConfig.setConnectionStatus(connectionStatus);
            aoJiraSiteConfig.setName(jiraSiteConfigRequest.getName());
            aoJiraSiteConfig.setUrl(jiraSiteConfigRequest.getUrl());
            aoJiraSiteConfig.save();
        }
        return (AoJiraSiteConfig)this.ao.get(AoJiraSiteConfig.class, (Object)id);
    }

    @Override
    @Nullable
    public AoJiraSiteConfig updateConnectionStatus(JiraSiteConfigConnectionUpdateRequest updateRequest) {
        AoJiraSiteConfig config = (AoJiraSiteConfig)this.ao.get(AoJiraSiteConfig.class, (Object)updateRequest.getId());
        if (config != null) {
            config.setConnectionStatus(updateRequest.getStatus());
            config.setConnectionErrorDescription(updateRequest.getMessage());
            config.save();
        }
        return config;
    }
}

