/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.stash.internal.jira.cloud.config.dao.AoJiraSiteConfig;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.java.ao.Accessor;
import net.java.ao.Preload;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.Table;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoJiraSiteConfigUpgradeTaskV1
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AoJiraSiteConfigUpgradeTaskV1.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This upgrade task can only upgrade from version 0 to 1");
        log.info("Migrating {} to version 1", (Object)"JIRA_SITE_CONFIG");
        activeObjects.migrate(new Class[]{AoJiraSiteConfigV0.class});
        log.trace("Deleting rows with duplicate CLIENT_ID from {}", (Object)"JIRA_SITE_CONFIG");
        MutableObject previous = new MutableObject();
        activeObjects.stream(AoJiraSiteConfigV0.class, AoUtils.newQuery((String[])AoJiraSiteConfigV0.ALL_COLUMNS).order("CLIENT_ID"), row -> {
            String currentClientId = row.getClientId();
            AoJiraSiteConfigV0 previousRow = (AoJiraSiteConfigV0)previous.getValue();
            if (previousRow != null && currentClientId.equals(previousRow.getClientId())) {
                activeObjects.deleteWithSQL(AoJiraSiteConfigV0.class, "ID = ?", new Object[]{row.getID()});
                AoJiraSiteConfigUpgradeTaskV1.logDeletedRow(row, previousRow);
            }
            previous.setValue((Object)row);
        });
        activeObjects.migrate(new Class[]{AoJiraSiteConfig.class});
        log.info("{} migration to version 1 complete.", (Object)"JIRA_SITE_CONFIG");
    }

    private static void logDeletedRow(AoJiraSiteConfigV0 currentRow, AoJiraSiteConfigV0 previousRow) {
        if (Objects.equals(previousRow.getClientSecret(), currentRow.getClientSecret()) && Objects.equals(previousRow.getCloudId(), currentRow.getCloudId()) && Objects.equals(previousRow.getUrl(), currentRow.getUrl())) {
            log.trace("Deleted duplicate row with CLIENT_ID {}", (Object)currentRow.getClientId());
        } else {
            log.warn("Deleted duplicate row with CLIENT_ID:{}, CLOUD_ID:{}, URL:{}", new Object[]{currentRow.getClientId(), currentRow.getCloudId(), currentRow.getUrl()});
        }
    }

    @Preload
    @Table(value="JIRA_SITE_CONFIG")
    public static interface AoJiraSiteConfigV0
    extends AoJiraSiteConfig {
        @Override
        @Accessor(value="CLIENT_ID")
        @NotNull
        public String getClientId();
    }
}

