/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config.service;

import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerConfiguration;
import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerConfigurationService
implements LifecycleAware {
    public static final String CONFIG_NAME = "jira-site-config";
    public static final String PROPERTY_CALLS_IN_HALF_OPEN = "plugin.jira-integration.circuitbreaker.callsinhalfopen";
    public static final String PROPERTY_ENABLED = "plugin.jira-integration.circuitbreaker.enabled";
    public static final String PROPERTY_FAILURE_THRESHOLD = "plugin.jira-integration.circuitbreaker.failurethreshold";
    public static final String PROPERTY_SLOW_CALL_THRESHOLD = "plugin.jira-integration.circuitbreaker.slowcallthreshold";
    public static final String PROPERTY_WAIT_IN_OPEN_STATE = "plugin.jira-integration.circuitbreaker.waitinopenstate";
    private static final Logger log = LoggerFactory.getLogger(CircuitBreakerConfigurationService.class);
    private static final int DEFAULT_CALLS_IN_HALF_OPEN = 10;
    private static final int DEFAULT_FAILURE_THRESHOLD = 50;
    private static final int DEFAULT_MINIMUM_CALLS_REQUIRED = 50;
    private static final int DEFAULT_SLOW_CALL_THRESHOLD = 2;
    private static final int DEFAULT_WAIT_IN_OPEN_STATE = 60;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final CircuitBreakerService circuitBreakerService;

    public CircuitBreakerConfigurationService(ApplicationPropertiesService applicationPropertiesService, CircuitBreakerService circuitBreakerService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void onStart() {
        if (this.circuitBreakerService.getConfiguration(CONFIG_NAME).isPresent()) {
            log.debug("Circuit breaker configuration {} for jira-development-integration already exists.", (Object)CONFIG_NAME);
        } else {
            log.debug("Adding circuit breaker configuration jira-development-integration");
            this.circuitBreakerService.addConfiguration(new CircuitBreakerConfiguration.Builder(CONFIG_NAME).exceptionsToIgnore(t -> t instanceof UnsupportedOperationException).failureThreshold((float)this.applicationPropertiesService.getPluginProperty(PROPERTY_FAILURE_THRESHOLD, 50)).minimumCallsRequired(50).numberOfCallsInHalfOpen(this.applicationPropertiesService.getPluginProperty(PROPERTY_CALLS_IN_HALF_OPEN, 10)).slowCallThreshold(Duration.ofSeconds(this.applicationPropertiesService.getPluginProperty(PROPERTY_SLOW_CALL_THRESHOLD, 2))).waitInOpenState(Duration.ofSeconds(this.applicationPropertiesService.getPluginProperty(PROPERTY_WAIT_IN_OPEN_STATE, 60))).writeStackTraces(false).setEnabled(this.applicationPropertiesService.getPluginProperty(PROPERTY_ENABLED, true)).build());
        }
    }

    public void onStop() {
    }
}

