/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config.service;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.jira.cloud.client.CloudIdResolvingClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudAuthClient;
import com.atlassian.stash.internal.jira.cloud.client.exception.CloudIdResolutionException;
import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigConnectionUpdateRequest;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigRequest;
import com.atlassian.stash.internal.jira.cloud.config.SimpleJiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.dao.AoJiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.dao.JiraSiteConfigDao;
import com.atlassian.stash.internal.jira.cloud.config.event.JiraSiteConfigCreatedEvent;
import com.atlassian.stash.internal.jira.cloud.config.event.JiraSiteConfigDeletedEvent;
import com.atlassian.stash.internal.jira.cloud.config.event.JiraSiteConfigUpdatedEvent;
import com.atlassian.stash.internal.jira.cloud.config.exception.InvalidOauthCredentialException;
import com.atlassian.stash.internal.jira.cloud.config.exception.JiraSiteConfigAlreadyExistsException;
import com.atlassian.stash.internal.jira.cloud.config.exception.JiraSiteConfigException;
import com.atlassian.stash.internal.jira.cloud.config.exception.JiraSiteConfigNotFoundException;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraSiteConfigService
implements JiraSiteConfigService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraSiteConfigService.class);
    private static final String ERROR_MSG_KEY = "bitbucket.jira-development-integration.jirasite.config.in.error";
    private final CloudIdResolvingClient cloudIdResolvingClient;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final JiraCloudAuthClient jiraCloudAuthClient;
    private final JiraSiteConfigDao jiraSiteConfigDao;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final Validator validator;

    public DefaultJiraSiteConfigService(CloudIdResolvingClient cloudIdResolvingClient, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, JiraCloudAuthClient jiraCloudAuthClient, JiraSiteConfigDao jiraSiteConfigDao, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, Validator validator) {
        this.cloudIdResolvingClient = cloudIdResolvingClient;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.jiraCloudAuthClient = jiraCloudAuthClient;
        this.jiraSiteConfigDao = jiraSiteConfigDao;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        this.validator = validator;
    }

    @Override
    @Nonnull
    public JiraSiteConfig create(final @Nonnull JiraSiteConfigRequest jiraSiteConfigRequest) {
        Objects.requireNonNull(jiraSiteConfigRequest, "request");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        ValidationUtils.validate((Validator)this.validator, (Object)jiraSiteConfigRequest, (Class[])new Class[0]);
        try {
            final String cloudId = this.cloudIdResolvingClient.getCloudId(jiraSiteConfigRequest.getUrl());
            this.validateOauthCredentials(jiraSiteConfigRequest, cloudId);
            return (JiraSiteConfig)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<JiraSiteConfig>(){

                public JiraSiteConfig doInTransaction() {
                    Optional<AoJiraSiteConfig> existing = DefaultJiraSiteConfigService.this.jiraSiteConfigDao.getByClientId(jiraSiteConfigRequest.getClientId());
                    if (existing.isPresent()) {
                        throw new JiraSiteConfigAlreadyExistsException(DefaultJiraSiteConfigService.this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.already.exists", new Object[0]));
                    }
                    AoJiraSiteConfig aoJiraSiteConfig = DefaultJiraSiteConfigService.this.jiraSiteConfigDao.create(jiraSiteConfigRequest, cloudId, ConnectionStatus.CONNECTED);
                    JiraSiteConfig jiraSiteConfig = DefaultJiraSiteConfigService.this.buildJiraSiteConfig(aoJiraSiteConfig);
                    DefaultJiraSiteConfigService.this.eventPublisher.publish((Object)new JiraSiteConfigCreatedEvent(this, jiraSiteConfig));
                    return jiraSiteConfig;
                }
            });
        }
        catch (CloudIdResolutionException e) {
            log.info("Failed to resolve cloud id", (Throwable)e);
            throw new JiraSiteConfigException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.cloud-id.fetch.failed", new Object[0]), e);
        }
        catch (InvalidOauthCredentialException e) {
            log.info("Failed to validate oauth credentials", (Throwable)((Object)e));
            throw e;
        }
        catch (JiraSiteConfigAlreadyExistsException e) {
            log.info("Jira site config already exists for client ID {}", (Object)jiraSiteConfigRequest.getClientId(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Exception encountered when updating jira site config", (Throwable)e);
            throw new JiraSiteConfigException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.error.update", new Object[0]), e);
        }
    }

    @Override
    public void delete(int id) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.transactionTemplate.execute(() -> {
            JiraSiteConfig jiraSiteConfig = this.getJiraSiteConfig(id);
            this.jiraSiteConfigDao.deleteById(id);
            this.eventPublisher.publish((Object)new JiraSiteConfigDeletedEvent(this, jiraSiteConfig));
            return null;
        });
    }

    @Override
    @Nonnull
    public JiraSiteConfig get(int id) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return this.getJiraSiteConfig(id);
    }

    @Override
    @Nonnull
    public Page<JiraSiteConfig> getAll(@Nonnull PageRequest pageRequest) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        if (!this.featureManager.isEnabled((Feature)StandardFeature.JIRA_CLOUD_DEV_INFO)) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.jiraSiteConfigDao.getAll(pageRequest).transform(this::buildJiraSiteConfig);
    }

    @Override
    public boolean hasAnySitesConfigured() {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.JIRA_CLOUD_DEV_INFO)) {
            return false;
        }
        return this.jiraSiteConfigDao.hasAnySitesConfigured();
    }

    @Override
    @Nonnull
    public JiraSiteConfig update(int id, @Nonnull JiraSiteConfigRequest jiraSiteConfigRequest) {
        Objects.requireNonNull(jiraSiteConfigRequest, "request");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        ValidationUtils.validate((Validator)this.validator, (Object)jiraSiteConfigRequest, (Class[])new Class[0]);
        return (JiraSiteConfig)this.transactionTemplate.execute(() -> {
            this.getJiraSiteConfig(id);
            try {
                String cloudId = this.cloudIdResolvingClient.getCloudId(jiraSiteConfigRequest.getUrl());
                this.validateOauthCredentials(jiraSiteConfigRequest, cloudId);
                AoJiraSiteConfig updatedAoJiraSiteConfig = this.jiraSiteConfigDao.update(id, jiraSiteConfigRequest, cloudId, ConnectionStatus.CONNECTED);
                JiraSiteConfig updatedJiraSiteConfig = this.buildJiraSiteConfig(updatedAoJiraSiteConfig);
                this.eventPublisher.publish((Object)new JiraSiteConfigUpdatedEvent(this, updatedJiraSiteConfig));
                return updatedJiraSiteConfig;
            }
            catch (CloudIdResolutionException e) {
                log.info("Failed to resolve cloud id", (Throwable)e);
                throw new JiraSiteConfigException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.cloud-id.fetch.failed", new Object[0]), e);
            }
            catch (InvalidOauthCredentialException e) {
                log.info("Failed to validate oauth credentials", (Throwable)((Object)e));
                throw e;
            }
            catch (Exception e) {
                log.error("Exception encountered when updating jira site config", (Throwable)e);
                throw new JiraSiteConfigException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.error.update", new Object[0]), e);
            }
        });
    }

    @Override
    public JiraSiteConfig updateConnectionStatus(@Nonnull JiraSiteConfigConnectionUpdateRequest updateRequest) {
        Objects.requireNonNull(updateRequest, "updateRequest");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return (JiraSiteConfig)this.transactionTemplate.execute(() -> {
            AoJiraSiteConfig aoConfig = this.jiraSiteConfigDao.updateConnectionStatus(updateRequest);
            if (aoConfig == null) {
                return null;
            }
            JiraSiteConfig config = this.buildJiraSiteConfig(aoConfig);
            this.eventPublisher.publish((Object)new JiraSiteConfigUpdatedEvent(this, config));
            return config;
        });
    }

    private JiraSiteConfig buildJiraSiteConfig(AoJiraSiteConfig aoJiraSiteConfig) {
        String errorDesc = aoJiraSiteConfig.getConnectionErrorDescription();
        if (aoJiraSiteConfig.getConnectionStatus() != ConnectionStatus.CONNECTED) {
            errorDesc = this.i18nService.getMessage(ERROR_MSG_KEY, new Object[]{errorDesc});
        }
        return new SimpleJiraSiteConfig.Builder().clientId(aoJiraSiteConfig.getClientId()).clientSecret(aoJiraSiteConfig.getClientSecret()).cloudId(aoJiraSiteConfig.getCloudId()).connectionStatus(aoJiraSiteConfig.getConnectionStatus()).connectionErrorDescription(errorDesc).id(aoJiraSiteConfig.getID()).name(aoJiraSiteConfig.getName()).url(aoJiraSiteConfig.getUrl()).build();
    }

    private JiraSiteConfig getJiraSiteConfig(int id) {
        return this.jiraSiteConfigDao.getById(id).map(this::buildJiraSiteConfig).orElseThrow(() -> new JiraSiteConfigNotFoundException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.not.found", new Object[0])));
    }

    private void validateOauthCredentials(JiraSiteConfigRequest jiraSiteConfigRequest, String cloudId) {
        try {
            this.jiraCloudAuthClient.validateOauthCredentials(jiraSiteConfigRequest.getClientId(), jiraSiteConfigRequest.getClientSecret(), cloudId);
        }
        catch (Exception e) {
            throw new InvalidOauthCredentialException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.jirasite.config.oauth.credentials.invalid", new Object[0]), e);
        }
    }
}

