/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.config.service;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import java.util.List;
import java.util.stream.Collectors;

public class EscalatedJiraSiteConfigSupplier {
    private static final int PAGE_SIZE = 5000;
    private final JiraSiteConfigService jiraSiteConfigService;
    private final SecurityService securityService;

    public EscalatedJiraSiteConfigSupplier(JiraSiteConfigService jiraSiteConfigService, SecurityService securityService) {
        this.jiraSiteConfigService = jiraSiteConfigService;
        this.securityService = securityService;
    }

    public List<JiraSiteConfig> getAll() {
        return (List)this.securityService.withPermission(Permission.ADMIN, "Obtaining Jira Site Configs").call(() -> PageUtils.toStream(this.jiraSiteConfigService::getAll, (int)5000).collect(Collectors.toList()));
    }
}

