/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.BranchChange;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch.BranchModel;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import com.atlassian.stash.internal.jira.cloud.sync.DeleteEntityRequest;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoConfig;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.listener.BranchChangeListener;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudBranchChangeListener
implements BranchChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CloudBranchChangeListener.class);
    private final CommitService commitService;
    private final DevInfoConfig config;
    private final DevInfoSender devInfoSender;
    private final JiraSiteConfigService jiraSiteConfigService;
    private final ModelConverter modelConverter;

    public CloudBranchChangeListener(CommitService commitService, DevInfoConfig config, DevInfoSender devInfoSender, JiraSiteConfigService jiraSiteConfigService, ModelConverter modelConverter) {
        this.commitService = commitService;
        this.config = config;
        this.devInfoSender = devInfoSender;
        this.jiraSiteConfigService = jiraSiteConfigService;
        this.modelConverter = modelConverter;
    }

    @Override
    public void onBranchChanges(@Nonnull Repository repository, @Nonnull Collection<BranchChange> branchChanges) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branchChanges);
        if (!this.jiraSiteConfigService.hasAnySitesConfigured()) {
            return;
        }
        if (branchChanges.size() > this.config.getMaxBranchesPerEvent()) {
            log.warn("{}: Received {} branch updates to send to Jira Cloud. Limiting to {} branches.", new Object[]{repository, branchChanges.size(), this.config.getMaxBranchesPerEvent()});
            branchChanges = branchChanges.stream().limit(this.config.getMaxBranchesPerEvent()).collect(Collectors.toList());
        }
        ArrayList<DeleteEntityRequest> deletes = new ArrayList<DeleteEntityRequest>();
        ArrayList<BranchChange> addsAndUpdates = new ArrayList<BranchChange>();
        branchChanges.stream().filter(change -> !change.getIssueKeys().isEmpty()).forEach(change -> {
            RefChangeType refChangeType = change.getRefChange().getType();
            switch (refChangeType) {
                case ADD: 
                case UPDATE: {
                    addsAndUpdates.add((BranchChange)change);
                    break;
                }
                case DELETE: {
                    deletes.add(new DeleteEntityRequest(repository, DevInfoType.BRANCH, change.getRefChange().getRef().getId()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown RefChangeType: " + String.valueOf(refChangeType));
                }
            }
        });
        log.debug("Sending branch events to Jira Cloud. Number of adds/updates: {}  Number of deletes: {}", (Object)addsAndUpdates.size(), (Object)deletes.size());
        if (!deletes.isEmpty()) {
            this.devInfoSender.delete(deletes);
        }
        if (!addsAndUpdates.isEmpty()) {
            Collection<BranchModel> addAndUpdateModels = this.convertToBranchModels(repository, addsAndUpdates);
            this.devInfoSender.send(repository, addAndUpdateModels);
        }
    }

    public Collection<BranchModel> convertToBranchModels(Repository repository, Collection<BranchChange> branchChanges) {
        Map<String, Commit> commitHashToCommit = this.loadTipCommits(repository, branchChanges);
        return branchChanges.stream().map(branchChange -> {
            Commit tipCommit = (Commit)commitHashToCommit.get(branchChange.getRefChange().getToHash());
            if (tipCommit == null) {
                log.debug("Unable to send dev info for branch '{}' because tip commit {} was missing.", (Object)branchChange.getRefChange().getToHash(), (Object)branchChange.getRefChange().getRef().getId());
                return null;
            }
            return this.modelConverter.toBranchModel(repository, branchChange.getRefChange(), branchChange.getIssueKeys(), tipCommit);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Map<String, Commit> loadTipCommits(Repository repository, Collection<BranchChange> branchChanges) {
        HashMap<String, Commit> commitHashToCommit = new HashMap<String, Commit>();
        Set tipCommits = branchChanges.stream().map(branchChange -> branchChange.getRefChange().getToHash()).collect(Collectors.toSet());
        BulkCommitsRequest bulkCommitsRequest = new BulkCommitsRequest.Builder().commits(repository, tipCommits).ignoreMissing(true).maxMessageLength(0).build();
        this.commitService.streamCommits(bulkCommitsRequest, (commit, repositories) -> {
            commitHashToCommit.put(commit.getId(), commit);
            return true;
        });
        return commitHashToCommit;
    }
}

