/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.stash.internal.jira.change.BuildStatusChange;
import com.atlassian.stash.internal.jira.cloud.sync.BuildStatusSender;
import com.atlassian.stash.internal.jira.listener.BuildStatusChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class CloudBuildStatusChangeListener
implements BuildStatusChangeListener {
    private final BuildStatusSender buildStatusSender;

    public CloudBuildStatusChangeListener(BuildStatusSender buildStatusSender) {
        this.buildStatusSender = buildStatusSender;
    }

    @Override
    public void onBuildStatusDeleted(@Nonnull BuildStatusChange buildStatusChange) {
        Objects.requireNonNull(buildStatusChange);
        this.buildStatusSender.delete(buildStatusChange.getBuildStatus());
    }

    @Override
    public void onBuildStatusSet(@Nonnull BuildStatusChange buildStatusChange) {
        Objects.requireNonNull(buildStatusChange);
        if (buildStatusChange.getIssueKeys().isEmpty()) {
            return;
        }
        this.buildStatusSender.send(buildStatusChange.getBuildStatus(), buildStatusChange.getIssueKeys());
    }
}

