/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.ChangesetsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.jira.change.CommitChange;
import com.atlassian.stash.internal.jira.change.CommitChangeType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitModel;
import com.atlassian.stash.internal.jira.cloud.sync.DeleteEntityRequest;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoConfig;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import com.atlassian.stash.internal.jira.util.CommitUserEnricher;
import com.atlassian.stash.internal.jira.util.CommitUserEnricherFactory;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudCommitChangeListener
implements CommitChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CloudCommitChangeListener.class);
    private int commitCount;
    private final Collection<CommitChange> commits;
    private final CommitService commitService;
    private final DevInfoConfig config;
    private final DevInfoSender devInfoSender;
    private final ModelConverter modelConverter;
    private final Repository repository;
    private final CommitUserEnricherFactory userEnricherFactory;

    public CloudCommitChangeListener(CommitService commitService, DevInfoConfig config, DevInfoSender devInfoSender, ModelConverter modelConverter, Repository repository, CommitUserEnricherFactory userEnricherFactory) {
        this.commitService = commitService;
        this.config = config;
        this.devInfoSender = devInfoSender;
        this.modelConverter = modelConverter;
        this.repository = repository;
        this.userEnricherFactory = userEnricherFactory;
        this.commitCount = 0;
        this.commits = new ArrayList<CommitChange>();
    }

    @Override
    public void onCommit(@Nonnull CommitChange commitChange) {
        Objects.requireNonNull(commitChange);
        if (++this.commitCount <= this.config.getMaxCommitsPerEvent()) {
            this.commits.add(commitChange);
        }
    }

    @Override
    public void onEnd() {
        if (this.commitCount > this.config.getMaxCommitsPerEvent()) {
            log.warn("{}: Received {} commits to send to Jira Cloud. Limiting to {} commits.", new Object[]{this.repository, this.commitCount, this.config.getMaxCommitsPerEvent()});
        }
        if (!this.commits.isEmpty()) {
            this.publishCommits();
        }
    }

    private Set<CommitModel> convertCommitChanges(Collection<CommitChange> commitChanges) {
        HashSet<CommitModel> commitModels = new HashSet<CommitModel>();
        Map commitIdToCommitChange = commitChanges.stream().collect(Collectors.toMap(commitChange -> commitChange.getCommit().getId(), Function.identity()));
        List<Changeset> changeSets = this.getChangeSets(this.repository, commitIdToCommitChange.keySet());
        CommitUserEnricher userEnricher = this.userEnricherFactory.create();
        changeSets.forEach(changeset -> {
            CommitChange commitChange = (CommitChange)commitIdToCommitChange.get(changeset.getToCommit().getId());
            Commit commit = commitChange.getCommit();
            Set<String> issueKeys = commitChange.getIssueKeys();
            Page changes = changeset.getChanges();
            Stream stream = changes != null ? changes.stream() : Stream.empty();
            Person enrichedAuthor = userEnricher.enrich(commit.getAuthor());
            commitModels.add(this.modelConverter.toCommitModel(this.repository, commit, enrichedAuthor, issueKeys, stream));
        });
        return commitModels;
    }

    private List<Changeset> getChangeSets(Repository repository, Set<String> commitIds) {
        ChangesetsRequest request = new ChangesetsRequest.Builder(repository).commitIds(commitIds).ignoreMissing(true).maxChangesPerCommit(this.config.getMaxFilesPerCommit()).messageLength(0).build();
        return PageUtils.toStream(pageRequest -> this.commitService.getChangesets(request, pageRequest), (int)commitIds.size()).collect(Collectors.toList());
    }

    private void publishCommits() {
        List<CommitChange> commitsAdded = this.commits.stream().filter(commitChange -> commitChange.getType() == CommitChangeType.ADDED).collect(Collectors.toList());
        List<DeleteEntityRequest> deleteRequests = this.commits.stream().filter(commitChange -> commitChange.getType() == CommitChangeType.REMOVED).map(commitChange -> commitChange.getCommit().getId()).map(commitId -> new DeleteEntityRequest(this.repository, DevInfoType.COMMIT, (String)commitId)).collect(Collectors.toList());
        log.debug("Sending commit events to Jira Cloud. Number of added commits: {}  Number of removed commits: {}", (Object)commitsAdded.size(), (Object)deleteRequests.size());
        if (!commitsAdded.isEmpty()) {
            Set<CommitModel> commitModels = this.convertCommitChanges(commitsAdded);
            this.devInfoSender.send(this.repository, commitModels);
        }
        this.devInfoSender.delete(deleteRequests);
    }
}

