/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import com.atlassian.stash.internal.jira.cloud.sync.CloudCommitChangeListener;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoConfig;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import com.atlassian.stash.internal.jira.listener.CommitChangeListenerFactory;
import com.atlassian.stash.internal.jira.listener.NoOpCommitChangeListener;
import com.atlassian.stash.internal.jira.util.CommitUserEnricherFactory;
import jakarta.annotation.Nonnull;

public class CloudCommitChangeListenerFactory
implements CommitChangeListenerFactory {
    private final CommitService commitService;
    private final DevInfoConfig config;
    private final DevInfoSender devInfoSender;
    private final JiraSiteConfigService jiraSiteConfigService;
    private final ModelConverter modelConverter;
    private final CommitUserEnricherFactory userEnricherFactory;

    public CloudCommitChangeListenerFactory(CommitService commitService, DevInfoConfig config, DevInfoSender devInfoSender, JiraSiteConfigService jiraSiteConfigService, ModelConverter modelConverter, CommitUserEnricherFactory userEnricherFactory) {
        this.commitService = commitService;
        this.config = config;
        this.devInfoSender = devInfoSender;
        this.jiraSiteConfigService = jiraSiteConfigService;
        this.modelConverter = modelConverter;
        this.userEnricherFactory = userEnricherFactory;
    }

    @Override
    public CommitChangeListener create(@Nonnull Repository repository) {
        if (this.jiraSiteConfigService.hasAnySitesConfigured()) {
            return new CloudCommitChangeListener(this.commitService, this.config, this.devInfoSender, this.modelConverter, repository, this.userEnricherFactory);
        }
        return new NoOpCommitChangeListener();
    }
}

