/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.stash.internal.jira.change.DeploymentChange;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDeploymentClient;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentsRequest;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.EscalatedJiraSiteConfigSupplier;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.listener.DeploymentChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class CloudDeploymentChangeListener
implements DeploymentChangeListener {
    private final JiraCloudDeploymentClient deploymentClient;
    private final EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier;
    private final ModelConverter modelConverter;

    public CloudDeploymentChangeListener(JiraCloudDeploymentClient deploymentClient, EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier, ModelConverter modelConverter) {
        this.deploymentClient = deploymentClient;
        this.jiraSiteConfigSupplier = jiraSiteConfigSupplier;
        this.modelConverter = modelConverter;
    }

    @Override
    public void onDeploymentEvent(@Nonnull DeploymentChange deploymentChange) {
        Objects.requireNonNull(deploymentChange, "deploymentChange");
        if (deploymentChange.getIssueKeys().isEmpty()) {
            return;
        }
        Deployment deployment = deploymentChange.getDeployment();
        DeploymentModel deploymentModel = this.modelConverter.toDeploymentModel(deployment, deploymentChange.getIssueKeys());
        switch (deploymentChange.getType()) {
            case INDEXED: 
            case UPDATED: {
                DeploymentsRequest deploymentsRequest = this.modelConverter.toDeploymentsRequest(deploymentModel, deployment.getRepository());
                this.jiraSiteConfigSupplier.getAll().forEach(jiraSiteConfig -> this.deploymentClient.sendDeployments((JiraSiteConfig)jiraSiteConfig, deploymentsRequest));
                break;
            }
            case DELETED: {
                this.jiraSiteConfigSupplier.getAll().forEach(jiraSiteConfig -> this.deploymentClient.deleteDeployments((JiraSiteConfig)jiraSiteConfig, deploymentModel));
            }
        }
    }
}

