/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.PullRequestChange;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.PullRequestModel;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import com.atlassian.stash.internal.jira.cloud.sync.DeleteEntityRequest;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.listener.PullRequestChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPullRequestChangeListener
implements PullRequestChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CloudPullRequestChangeListener.class);
    private final DevInfoSender devInfoSender;
    private final JiraSiteConfigService configService;
    private final ModelConverter modelConverter;

    public CloudPullRequestChangeListener(JiraSiteConfigService configService, DevInfoSender devInfoSender, ModelConverter modelConverter) {
        this.configService = configService;
        this.devInfoSender = devInfoSender;
        this.modelConverter = modelConverter;
    }

    @Override
    public void onPullRequestUpdated(@Nonnull PullRequestChange pullRequestChange) {
        Objects.requireNonNull(pullRequestChange);
        Set<String> issueKeys = pullRequestChange.getIssueKeys();
        if (issueKeys.isEmpty()) {
            return;
        }
        if (!this.configService.hasAnySitesConfigured()) {
            return;
        }
        PullRequest pullRequest = pullRequestChange.getPullRequest();
        Repository repository = pullRequest.getToRef().getRepository();
        if (pullRequestChange.getAction() == PullRequestAction.DELETED) {
            log.debug("Incorrect call to onPullRequestUpdated. Delegating to onPullRequestDeleted");
            this.onPullRequestDeleted(repository, pullRequest.getId(), issueKeys);
        }
        log.debug("Sending pull request {} event to Cloud", (Object)pullRequestChange.getAction());
        PullRequestModel pullRequestModel = this.modelConverter.toPullRequestModel(repository, pullRequest, issueKeys);
        this.devInfoSender.send(repository, Collections.singleton(pullRequestModel));
    }

    @Override
    public void onPullRequestDeleted(@Nonnull Repository repository, @Nonnull Long pullRequestId, @Nonnull Set<String> linkedIssues) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(pullRequestId, "pullRequestId");
        if (!this.configService.hasAnySitesConfigured()) {
            return;
        }
        log.debug("Sending pull request DELETED event to Cloud");
        DeleteEntityRequest deleteRequest = new DeleteEntityRequest(repository, DevInfoType.PULL_REQUEST, String.valueOf(pullRequestId));
        this.devInfoSender.delete(Collections.singletonList(deleteRequest));
    }
}

