/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudBuildStatusClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDeploymentClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDevInfoClient;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.EscalatedJiraSiteConfigSupplier;
import com.atlassian.stash.internal.jira.listener.RepositoryChangeListener;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudRepositoryChangeListener
implements RepositoryChangeListener {
    private static final Logger log = LoggerFactory.getLogger(CloudRepositoryChangeListener.class);
    private final JiraCloudBuildStatusClient buildStatusClient;
    private final JiraCloudDeploymentClient deploymentClient;
    private final JiraCloudDevInfoClient devInfoClient;
    private final EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier;

    public CloudRepositoryChangeListener(JiraCloudBuildStatusClient buildStatusClient, JiraCloudDeploymentClient deploymentClient, JiraCloudDevInfoClient devInfoClient, EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier) {
        this.buildStatusClient = buildStatusClient;
        this.deploymentClient = deploymentClient;
        this.devInfoClient = devInfoClient;
        this.jiraSiteConfigSupplier = jiraSiteConfigSupplier;
    }

    @Override
    public void onRepositoryDeleted(@Nonnull Repository repository, @Nonnull Set<String> linkedIssues) {
        Objects.requireNonNull(repository);
        List<JiraSiteConfig> sites = this.jiraSiteConfigSupplier.getAll();
        if (sites.isEmpty()) {
            return;
        }
        log.debug("Sending delete to Jira Cloud for repository {}", (Object)repository);
        for (JiraSiteConfig siteConfig : sites) {
            this.buildStatusClient.deleteBuildStatus(siteConfig, repository);
            this.devInfoClient.deleteDevInfo(siteConfig, repository);
            this.deploymentClient.deleteDeployments(siteConfig, repository);
        }
    }
}

