/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudBuildStatusClient;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusRequest;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.EscalatedJiraSiteConfigSupplier;
import com.atlassian.stash.internal.jira.cloud.sync.BuildStatusSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DefaultBuildStatusSender
implements BuildStatusSender {
    private final JiraCloudBuildStatusClient jiraCloudBuildStatusClient;
    private final EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier;
    private final ModelConverter modelConverter;

    public DefaultBuildStatusSender(EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier, ModelConverter modelConverter, JiraCloudBuildStatusClient jiraCloudBuildStatusClient) {
        this.jiraSiteConfigSupplier = jiraSiteConfigSupplier;
        this.modelConverter = modelConverter;
        this.jiraCloudBuildStatusClient = jiraCloudBuildStatusClient;
    }

    @Override
    public void delete(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        List<JiraSiteConfig> sites = this.jiraSiteConfigSupplier.getAll();
        if (sites.isEmpty()) {
            return;
        }
        BuildStatusModel buildStatusModel = this.modelConverter.toBuildStatusModel(buildStatus, (Set<String>)ImmutableSet.of());
        for (JiraSiteConfig siteConfig : sites) {
            this.jiraCloudBuildStatusClient.deleteBuildStatus(siteConfig, buildStatusModel);
        }
    }

    @Override
    public void send(@Nonnull RepositoryBuildStatus buildStatus, @Nonnull Set<String> issueKeys) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        Objects.requireNonNull(issueKeys, "issueKeys");
        List<JiraSiteConfig> sites = this.jiraSiteConfigSupplier.getAll();
        if (sites.isEmpty()) {
            return;
        }
        BuildStatusRequest buildStatusRequest = this.buildStatusRequest(buildStatus, issueKeys);
        for (JiraSiteConfig siteConfig : sites) {
            this.jiraCloudBuildStatusClient.sendBuildStatus(siteConfig, buildStatusRequest);
        }
    }

    private BuildStatusRequest buildStatusRequest(RepositoryBuildStatus buildStatus, Set<String> issueKeys) {
        BuildStatusModel buildStatusModel = this.modelConverter.toBuildStatusModel(buildStatus, issueKeys);
        return this.modelConverter.toBuildStatusRequest(buildStatusModel, buildStatus.getRepository());
    }
}

